# Integrations
**Edit this Page** [![N|Solid](./img/GitHub-Mark-32px.png)](https://github.com/mermaid-js/mermaid/blob/develop/docs/n00b-gettingStarted.md)

The following is a list of different integrations and plugins where mermaid is being used

## Productivity

- [GitLab](https://docs.gitlab.com/ee/user/markdown.html#diagrams-and-flowcharts) (**Native support**)
- [Azure Devops](https://docs.microsoft.com/en-us/azure/devops/project/wiki/wiki-markdown-guidance?view=azure-devops#add-mermaid-diagrams-to-a-wiki-page) (**Native support**)
- [GitHub](https://github.com)
  - [Github action: Compile mermaid to image](https://github.com/neenjaw/compile-mermaid-markdown-action)
  - [svg-generator](https://github.com/SimonKenyonShepard/mermaidjs-github-svg-generator)
- [GitBook](http://gitbook.com)
  - [Mermaid Plugin](https://github.com/JozoVilcek/gitbook-plugin-mermaid)
  - [Markdown with Mermaid CLI](https://github.com/miao1007/gitbook-plugin-mermaid-cli)
  - [Mermaid plugin for GitBook](https://github.com/wwformat/gitbook-plugin-mermaid-pdf)
- [Atlassian Products](https://www.atlassian.com)
  - [Mermaid Plugin for Confluence](https://marketplace.atlassian.com/apps/1214124/mermaid-plugin-for-confluence?hosting=server&tab=overview)
  - [CloudScript.io Addon](https://marketplace.atlassian.com/apps/1219878/cloudscript-io-mermaid-addon?hosting=cloud&tab=overview)
  - [Auto convert diagrams in Jira](https://github.com/coddingtonbear/jirafs-mermaid)
- [Redmine](https://redmine.org)
  - [Mermaid Macro](https://www.redmine.org/plugins/redmine_mermaid_macro)
  - [redmine-mermaid](https://github.com/styz/redmine_mermaid)
  - [markdown-for-mermaid-plugin](https://github.com/jamieh-mongolian/markdown-for-mermaid-plugin)

## CRM/ERP/Similar

  - [coreBOS](http://blog.corebos.org/blog/december2019)

## Blogs

- [Wordpress](https://wordpress.org)
  - [WordPress Markdown Editor](https://wordpress.org/plugins/wp-githuber-md)
  - [WP-ReliableMD](https://wordpress.org/plugins/wp-reliablemd/)
- [Hexo](https://hexo.io)
  - [hexo-filter-mermid-diagrams](https://github.com/webappdevelp/hexo-filter-mermaid-diagrams)
  - [hexo-tag-mermaid](https://github.com/JameChou/hexo-tag-mermaid)
  - [hexo-mermaid-diagrams](https://github.com/mslxl/hexo-mermaid-diagrams)

## CMS

- [VuePress](https://vuepress.vuejs.org/)
  - [Plugin for Mermaid.js](https://github.com/eFrane/vuepress-plugin-mermaidjs)
  - [vuepress-plugin-mermaidjs-cli](https://github.com/gwleclerc/vuepress-plugin-mermaidjs-cli)
- [Grav CMS](https://getgrav.org/)
  - [Mermaid Diagrams](https://github.com/DanielFlaum/grav-plugin-mermaid-diagrams)
  - [Gitlab Markdown Adapter](https://github.com/Goutte/grav-plugin-gitlab-markdown-adapter)

## Communication

- [Discourse](https://discourse.org)
  - [Mermaid Plugin](https://github.com/pnewell/discourse-mermaid), [And](https://github.com/unfoldingWord-dev/discourse-mermaid)
- [Mattermost](https://mattermost.com/)
  - [Mermaid Plugin](https://github.com/SpikeTings/Mermaid)
- [phpBB](https://phpbb.com)
  - [phpbb-ext-mermaid](https://github.com/AlfredoRamos/phpbb-ext-mermaid)
- [NodeBB](https://nodebb.org)
  - [Mermaid Plugin](https://www.npmjs.com/package/nodebb-plugin-mermaid)

## Wikis

- [Media Wiki](https://www.mediawiki.org/wiki/Extension:Mermaid)
- [Semantic Media Wiki](https://semantic-mediawiki.org)
  - [Mermaid Plugin](https://github.com/SemanticMediaWiki/Mermaid)
- [FosWiki](https://foswiki.org)
  - [Mermaid Plugin](https://foswiki.org/Extensions/MermaidPlugin)
- [DokuWiki](https://dokuwiki.org)
  - [Flowcharts](https://www.dokuwiki.org/plugin:flowcharts?s[]=mermaid)
- [TiddlyWiki](https://tiddlywiki.com/)
  - [mermaid-tw5-plugin](https://github.com/michaeljmcd/mermaid-tw5-plugin)

## Editor Plugins

- [Vs Code](https://code.visualstudio.com/)
  - [Markdown Preview Mermaid Support](https://marketplace.visualstudio.com/items?itemName=bierner.markdown-mermaid)
  - [Mermaid Preview](https://marketplace.visualstudio.com/items?itemName=vstirbu.vscode-mermaid-preview)
  - [Mermaid Markdown Syntax Highlighting](https://marketplace.visualstudio.com/items?itemName=bpruitt-goddard.mermaid-markdown-syntax-highlighting)
  - [Mermaid Editor](https://marketplace.visualstudio.com/items?itemName=tomoyukim.vscode-mermaid-editor)
  - [Mermaid Export](https://marketplace.visualstudio.com/items?itemName=Gruntfuggly.mermaid-export)
  - [Markdown PDF](https://marketplace.visualstudio.com/items?itemName=yzane.markdown-pdf)
  - [Preview](https://marketplace.visualstudio.com/items?itemName=searKing.preview-vscode)
  - [Preview Sequence Diagrams](https://marketplace.visualstudio.com/items?itemName=arichika.previewseqdiag-vscode)
- [Markdown-It](https://github.com/markdown-it/markdown-it)
  - [Textual UML Parser](https://github.com/manastalukdar/markdown-it-textual-uml)
  - [Mermaid Plugin](https://github.com/tylingsoft/markdown-it-mermaid)
  - [md-it-mermaid](https://github.com/iamcco/md-it-mermaid)
  - [markdown-it-mermaid-fence-new](https://github.com/Revomatico/markdown-it-mermaid-fence-new)
  - [markdown-it-mermaid-less](https://github.com/searKing/markdown-it-mermaid-less)
- [Atom](https://atom.io)
  - [Markdown Preview Enhanced](https://atom.io/packages/markdown-preview-enhanced)
  - [Atom Mermaid](https://atom.io/packages/atom-mermaid)
  - [Language Mermaid Syntax Highlighter](https://atom.io/packages/language-mermaid)
- [Sublime Text 3](https://sublimetext.com)
  - [Mermaid Package](https://packagecontrol.io/packages/Mermaid)
- [Astah](http://astah.net)
  - [Export to Mermaid](https://github.com/Avens666/Astah_Jude_UML_export_to_Markdown-mermaid-Plantuml-)
- [Light Table](http://lighttable.com/)
  - [Mermaid Plugin](https://github.com/cldwalker/Mermaid)
- [Draw.io](http://draw.io) - [Plugin](https://github.com/nopeslide/drawio_mermaid_plugin)
- [Inkdrop](http://inkdrop.app) - [Plugin](https://github.com/inkdropapp/inkdrop-mermaid)
- [Vim](https://vim.org)
  - [Vim Diagram Syntax](https://github.com/zhaozg/vim-diagram)
- [Brackets](http://brackets.io/)
  - [Mermaid Preview](https://s3.amazonaws.com/extend.brackets/alanhohn.mermaid-preview/alanhohn.mermaid-preview-1.0.2.zip)
- [Iodide](https://github.com/iodide-project/iodide)
  - [iodide-mermaid-plugin](https://github.com/iodide-project/iodide-mermaid-plugin)

## Document Generation

- [Sphinx](https://www.sphinx-doc.org/en/master/)
  - [sphinxcontrib-mermaid](https://github.com/mgaitan/sphinxcontrib-mermaid)
- [remark.js](https://remark.js.org/)
  - [remark-mermaid](https://github.com/temando/remark-mermaid)
- [jSDoc](https://jsdoc.app/)
  - [jsdoc-mermaid](https://github.com/Jellyvision/jsdoc-mermaid)
- [MkDocs](https://mkdocs.org)
  - [MarkdownMermaid](https://github.com/sebastienwarin/mkdocs-mermaid-plugin)
- [Type Doc](https://typedoc.org/)
  - [typedoc-plugin-mermaid](https://www.npmjs.com/package/typedoc-plugin-mermaid)

## Chrome Extensions

- [Mermaid Diagrams](https://chrome.google.com/webstore/detail/mermaid-diagrams/phfcghedmopjadpojhmmaffjmfiakfil)
- [GitHub + Mermaid](https://chrome.google.com/webstore/detail/github-%2B-mermaid/goiiopgdnkogdbjmncgedmgpoajilohe)
- [Mermaid Markdown](https://chrome.google.com/webstore/detail/mermaid-markdown/mboeoikjijmjcjgpccghbcoegikliijg)
- [Monkeys](https://chrome.google.com/webstore/detail/monkeys-mermaid-for-githu/cplfdpoajbclbgphaphphcldamfkjlgi)
- [Asciidoctor Live Preview](https://chrome.google.com/webstore/detail/asciidoctorjs-live-previe/iaalpfgpbocpdfblpnhhgllgbdbchmia) __works in the new IE as well__
- [Chrome Diagrammer](https://chrome.google.com/webstore/detail/chrome-diagrammer/bkpbgjmkomfoakfklcjeoegkklgjnnpk)
- [Diagram Tab](https://github.com/khafast/diagramtab)

## Other

- [Jekyll](https://jekyllrb.com/)
  - [jekyll-mermaid](https://rubygems.org/gems/jekyll-mermaid)
  - [jekyll-mermaid-diagrams](https://github.com/fuzhibo/jekyll-mermaid-diagrams)
- [Reveal.js](https://github.com/hakimel/reveal.js)
  - [reveal.js-mermaid-plugin](https://github.com/ludwick/reveal.js-mermaid-plugin)
- [Bisheng](https://www.npmjs.com/package/bisheng)
  - [bisheng-plugin-mermaid](https://github.com/yct21/bisheng-plugin-mermaid)
- [Reveal CK](https://github.com/jedcn/reveal-ck)
  - [reveal-ck-mermaid-plugin](https://github.com/tmtm/reveal-ck-mermaid-plugin)
- [mermaid-server: Generate diagrams using a HTTP request](https://github.com/TomWright/mermaid-server)
