macro(add_backend backend_id cond_var)
  if(${cond_var})
    include("${CMAKE_CURRENT_LIST_DIR}/detect_${backend_id}.cmake")
  endif()
endmacro()

function(ocv_add_external_target name inc link def)
  if(BUILD_SHARED_LIBS)
    set(imp IMPORTED)
  endif()
  add_library(ocv.3rdparty.${name} INTERFACE ${imp})
  set_target_properties(ocv.3rdparty.${name} PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${inc}"
    INTERFACE_SYSTEM_INCLUDE_DIRECTORIES "${inc}"
    INTERFACE_COMPILE_DEFINITIONS "${def}")
  # When cmake version is greater than or equal to 3.11, INTERFACE_LINK_LIBRARIES no longer applies to interface library
  # See https://github.com/opencv/opencv/pull/18658
  if (CMAKE_VERSION VERSION_LESS 3.11)
    set_target_properties(ocv.3rdparty.${name} PROPERTIES
      INTERFACE_LINK_LIBRARIES "${link}")
  else()
    target_link_libraries(ocv.3rdparty.${name} INTERFACE ${link})
  endif()
  #
  if(NOT BUILD_SHARED_LIBS)
    install(TARGETS ocv.3rdparty.${name} EXPORT OpenCVModules)
  endif()
endfunction()

add_backend("ffmpeg" WITH_FFMPEG)
add_backend("gstreamer" WITH_GSTREAMER)
add_backend("v4l" WITH_V4L)

add_backend("aravis" WITH_ARAVIS)
add_backend("dc1394" WITH_1394)
add_backend("gphoto" WITH_GPHOTO2)
add_backend("msdk" WITH_MFX)
add_backend("openni2" WITH_OPENNI2)
add_backend("pvapi" WITH_PVAPI)
add_backend("realsense" WITH_LIBREALSENSE)
add_backend("ueye" WITH_UEYE)
add_backend("ximea" WITH_XIMEA)
add_backend("xine" WITH_XINE)

add_backend("avfoundation" WITH_AVFOUNDATION)
add_backend("ios" WITH_CAP_IOS)

add_backend("dshow" WITH_DSHOW)
add_backend("msmf" WITH_MSMF)

add_backend("android_mediandk" WITH_ANDROID_MEDIANDK)
