# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.hybridnetwork import HybridNetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hybridnetwork
# USAGE
    python network_function_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HybridNetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.network_functions.begin_create_or_update(
        resource_group_name="rg",
        network_function_name="testNf",
        parameters={
            "location": "eastus",
            "properties": {
                "device": {
                    "id": "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/devices/testDevice"
                },
                "managedApplicationParameters": {},
                "networkFunctionUserConfigurations": [
                    {
                        "networkInterfaces": [
                            {
                                "ipConfigurations": [
                                    {
                                        "dnsServers": None,
                                        "gateway": "",
                                        "ipAddress": "",
                                        "ipAllocationMethod": "Dynamic",
                                        "ipVersion": "IPv4",
                                        "subnet": "",
                                    }
                                ],
                                "macAddress": "",
                                "networkInterfaceName": "nic1",
                                "vmSwitchType": "Management",
                            },
                            {
                                "ipConfigurations": [
                                    {
                                        "dnsServers": None,
                                        "gateway": "",
                                        "ipAddress": "",
                                        "ipAllocationMethod": "Dynamic",
                                        "ipVersion": "IPv4",
                                        "subnet": "",
                                    }
                                ],
                                "macAddress": "DC-97-F8-79-16-7D",
                                "networkInterfaceName": "nic2",
                                "vmSwitchType": "Wan",
                            },
                        ],
                        "roleName": "testRole",
                        "userDataParameters": {},
                    }
                ],
                "skuName": "testSku",
                "skuType": "SDWAN",
                "vendorName": "testVendor",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/preview/2022-01-01-preview/examples/NetworkFunctionCreate.json
if __name__ == "__main__":
    main()
