#  SPDX-FileCopyrightText: 2025 Greenbone AG
#
#  SPDX-License-Identifier: GPL-3.0-or-later

from gvm.protocols.gmp.requests.next._agent_groups import AgentGroups
from gvm.protocols.gmp.requests.next._agent_installers import AgentInstallers
from gvm.protocols.gmp.requests.next._agents import Agents
from gvm.protocols.gmp.requests.next._credential_stores import CredentialStores
from gvm.protocols.gmp.requests.next._credentials import (
    Credentials,
    CredentialStoreCredentialType,
)
from gvm.protocols.gmp.requests.next._oci_image_targets import OCIImageTargets
from gvm.protocols.gmp.requests.next._tasks import Tasks

from .._entity_id import EntityID
from .._version import Version
from ..v227 import (
    Aggregates,
    AggregateStatistic,
    AlertCondition,
    AlertEvent,
    AlertMethod,
    Alerts,
    AliveTest,
    AuditReports,
    Audits,
    Authentication,
    CertBundAdvisories,
    Cpes,
    CredentialFormat,
    CredentialType,
    Cves,
    DfnCertAdvisories,
    EntityType,
    Feed,
    FeedType,
    Filters,
    FilterType,
    Groups,
    Help,
    HelpFormat,
    Hosts,
    HostsOrdering,
    InfoType,
    Notes,
    Nvts,
    OperatingSystems,
    Overrides,
    Permissions,
    PermissionSubjectType,
    Policies,
    PortLists,
    PortRangeType,
    ReportConfigParameter,
    ReportConfigs,
    ReportFormats,
    ReportFormatType,
    Reports,
    ResourceNames,
    ResourceType,
    Results,
    Roles,
    ScanConfigs,
    Scanners,
    ScannerType,
    Schedules,
    SecInfo,
    Severity,
    SnmpAuthAlgorithm,
    SnmpPrivacyAlgorithm,
    SortOrder,
    SystemReports,
    Tags,
    Targets,
    Tickets,
    TicketStatus,
    TLSCertificates,
    TrashCan,
    UserAuthType,
    Users,
    UserSettings,
    Vulnerabilities,
)

__all__ = (
    "AgentGroups",
    "AgentInstallers",
    "Agents",
    "Aggregates",
    "AggregateStatistic",
    "Alerts",
    "AlertCondition",
    "AlertEvent",
    "AlertMethod",
    "AliveTest",
    "AuditReports",
    "Audits",
    "Authentication",
    "CertBundAdvisories",
    "Cpes",
    "Credentials",
    "CredentialFormat",
    "CredentialType",
    "CredentialStoreCredentialType",
    "CredentialStores",
    "Cves",
    "DfnCertAdvisories",
    "EntityID",
    "EntityType",
    "Feed",
    "FeedType",
    "Filters",
    "FilterType",
    "Groups",
    "Help",
    "HelpFormat",
    "Hosts",
    "HostsOrdering",
    "InfoType",
    "Notes",
    "Nvts",
    "OCIImageTargets",
    "OperatingSystems",
    "Overrides",
    "Permissions",
    "PermissionSubjectType",
    "Policies",
    "PortLists",
    "PortRangeType",
    "ReportConfigs",
    "ReportConfigParameter",
    "ReportFormatType",
    "ReportFormats",
    "Reports",
    "ResourceNames",
    "ResourceType",
    "Results",
    "Roles",
    "ScanConfigs",
    "Scanners",
    "ScannerType",
    "Schedules",
    "SecInfo",
    "Severity",
    "SortOrder",
    "SnmpAuthAlgorithm",
    "SnmpPrivacyAlgorithm",
    "SystemReports",
    "Tags",
    "Targets",
    "Tasks",
    "Tickets",
    "TicketStatus",
    "TLSCertificates",
    "TrashCan",
    "UserAuthType",
    "UserSettings",
    "Users",
    "Version",
    "Vulnerabilities",
)
