% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-ac.R
\name{autocor-terms}
\alias{autocor-terms}
\title{Autocorrelation structures}
\description{
Specify autocorrelation terms in \pkg{brms} models. Currently supported terms
are \code{\link{arma}}, \code{\link{ar}}, \code{\link{ma}},
\code{\link{cosy}}, \code{\link{unstr}}, \code{\link{sar}},
\code{\link{car}}, and \code{\link{fcor}}. Terms can be directly specified
within the formula, or passed to the \code{autocor} argument of
\code{\link{brmsformula}} in the form of a one-sided formula. For deprecated
ways of specifying autocorrelation terms, see \code{\link{cor_brms}}.
}
\details{
The autocor term functions are almost solely useful when called in
formulas passed to the \pkg{brms} package. They do not evaluate its
arguments -- but exist purely to help set up a model with autocorrelation
terms.
}
\examples{
# specify autocor terms within the formula
y ~ x + arma(p = 1, q = 1) + car(M)

# specify autocor terms in the 'autocor' argument
bf(y ~ x, autocor = ~ arma(p = 1, q = 1) + car(M))

# specify autocor terms via 'acformula'
bf(y ~ x) + acformula(~ arma(p = 1, q = 1) + car(M))
}
\seealso{
\code{\link{brmsformula}}, \code{\link{acformula}},
  \code{\link{arma}}, \code{\link{ar}}, \code{\link{ma}},
  \code{\link{cosy}}, \code{\link{unstr}}, \code{\link{sar}},
  \code{\link{car}}, \code{\link{fcor}}
}
