% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{format.CFTime}
\alias{format.CFTime}
\title{Format the timestamps in the \code{CFTime} instance}
\usage{
\method{format}{CFTime}(x, format = "", tz = "", usetz = FALSE, ...)
}
\arguments{
\item{x}{The \code{CFTime} instance whose timestamps will be formatted.}

\item{format}{A character string. The default for the format methods is
"\%Y-\%m-\%dT\%H:\%M:\%S" if any timestamp has a time component which is not
midnight, and "\%Y-\%m-\%d" otherwise. The only supported specifiers are
\verb{bBdeFhHImMpRSTYz\%}. Modifiers \code{E} and \code{O} are silently ignored. Other
specifiers, including their percent sign, are copied to the output as if
they were adorning text.}

\item{tz}{Ignored.}

\item{usetz}{Logical. Should the time zone offset be appended to the output?
This is always in numerical form, i.e. "-0800", from UTC.}

\item{...}{Ignored.}
}
\description{
The formatting is largely oblivious to locale. The reason for this is
that certain dates in certain calendars are not POSIX-compliant and the
system functions necessary for locale information thus do not work
consistently. The main exception to this is the (abbreviated) names of
months (\code{bB}), which could be useful for pretty printing in the local
language. For separators and other locale-specific adornments, use
local knowledge instead of depending on system locale settings; e.g.
specify \verb{\%m/\%d/\%Y} instead of \verb{\%D}.
}
\details{
Week information, including weekday names, is not supported at all as a
"week" is not defined for non-standard CF calendars and not generally
useful for climate projection data. If you are working with observed
data and want to get pretty week formats, use the \code{\link[=as_timestamp]{as_timestamp()}}
method to generate \code{POSIXct} timestamps (observed data generally uses a
"standard" calendar) and then use the \code{\link[base:format]{base::format()}} function which
supports the full set of specifiers.
}
