% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-iterm.R
\name{scale_color_iterm}
\alias{scale_color_iterm}
\alias{scale_colour_iterm}
\alias{scale_fill_iterm}
\title{iTerm color scales}
\usage{
scale_color_iterm(
  palette = iterm_palettes(),
  variant = c("normal", "bright"),
  alpha = 1,
  ...
)

scale_colour_iterm(
  palette = iterm_palettes(),
  variant = c("normal", "bright"),
  alpha = 1,
  ...
)

scale_fill_iterm(
  palette = iterm_palettes(),
  variant = c("normal", "bright"),
  alpha = 1,
  ...
)
}
\arguments{
\item{palette}{Palette name. See \code{\link[=iterm_palettes]{iterm_palettes()}} for available options.}

\item{variant}{Variant of the palette. One of \code{"normal"}, \code{"bright"}.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_iterm]{pal_iterm()}} for details.
}
\details{
Preview all available iTerm color palettes in ggsci:
\url{https://nanx.me/ggsci-iterm/}.
}
\examples{
example_scatterplot() + scale_color_iterm("Rose Pine")
example_barplot() + scale_fill_iterm("Rose Pine")
}
