% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ping-package.R
\name{ping_port}
\alias{ping_port}
\alias{is_up}
\title{Check if a port of a server is active, measure response time}
\usage{
ping_port(
  destination,
  port = 80L,
  continuous = FALSE,
  verbose = continuous,
  count = 3L,
  timeout = 1
)

is_up(
  destination,
  port = 80,
  timeout = 0.5,
  fail_on_dns_error = FALSE,
  check_online = TRUE
)
}
\arguments{
\item{destination}{Host name or IP address.}

\item{port}{Port.}

\item{continuous}{Logical, whether to keep pinging until
the user interrupts.}

\item{verbose}{Whether to print progress on the screen while
pinging.}

\item{count}{Number of pings to perform.}

\item{timeout}{Timeout, in seconds. How long to wait for a
ping to succeed.}

\item{fail_on_dns_error}{If \code{TRUE} then \code{is_up()} fails if the DNS
resolution fails. Otherwise it will return \code{FALSE}.}

\item{check_online}{Whether to check first if the computer is online.
Otherwise it is possible that the computer is behind a proxy, that
hijacks the HTTP connection to \code{destination}.}
}
\value{
Vector of response times, in milliseconds.
\code{NA} means no response within the timeout.
}
\description{
Check if a port of a server is active, measure response time

\code{is_up()} checks if a web server is up.
}
\examples{
\dontshow{if (pingr:::safe_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ping_port("r-project.org")
\dontshow{\}) # examplesIf}
\dontshow{if (pingr:::safe_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_up("google.com")
is_up("google.com", timeout = 0.01)
\dontshow{\}) # examplesIf}
}
