## RabbitMQ 3.8.14

RabbitMQ `3.8.14` is a maintenance release that restores
Erlang 22.3 compatibility for environments that use [direct reply-to](/direct-reply-to.html).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 22.3](https://www.rabbitmq.com/which-erlang.html).
[Erlang 23](http://blog.erlang.org/OTP-23-Highlights/) is highly recommended
for best forward compatibility with future RabbitMQ versions.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision a recent version of Erlang `23.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 23.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 23.x, then RabbitMQ to the most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * [Direct reply-to](https://www.rabbitmq.com/direct-reply-to.html) failed witn an exception on Erlang 22.3.
   Nodes running on Erlang 23 are not affected.

   GitHub issue: [#2857](https://github.com/rabbitmq/rabbitmq-server/pull/2857)

 * A warnings about async I/O threads was replaced with a similar one about dirty I/O
   schedulers. This keeps the message up with the settings used in modern Erlang releases.

   GitHub issue: [#2854](https://github.com/rabbitmq/rabbitmq-server/pull/2854)

### Other

#### Enhancements

 * Community-maintained [RabbitMQ OCF scripts](https://github.com/rabbitmq/rabbitmq-server/blob/master/scripts/rabbitmq-server-ha.ocf) were revisited.

   Contributed by Michele @mbaldessari Baldessari.

   GitHub issue: [#2853](https://github.com/rabbitmq/rabbitmq-server/pull/2853)


## Dependency Upgrades

 There were no dependency changes.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.14.tar.xz`
instead of the source tarball produced by GitHub.
