#ifndef LIBUCSV_H
#define LIBUCSV_H

#include <stdio.h>

typedef enum {
	UCSV_MORE,
	UCSV_END,
	UCSV_TOK_TEXT,
	UCSV_TOK_END_LINE
} ucsv_token_t;

typedef enum { /* bitfield */
	UCSV_NONE    = 0,
	UCSV_SQUOTE  = 1,  /* '' */
	UCSV_DQUOTE  = 2,  /* "" */
	UCSV_ESCAPE  = 4   /* \ */
} ucsv_state_t;

typedef struct ucsv_ctx_s {
	ucsv_state_t state;
	char *buf;
	int alloced, used;

	/* config - all 0 means RFC4180 compliant */
	unsigned enable_squote:1;         /* enable single quote for quoting cells */
	unsigned enable_backslash:1;      /* enable backslash as an escape character */
	unsigned disable_dqdq:1;          /* disable "" to be interpreted az a literal " */

	/* cache */
	char last;
	unsigned forced_eof:1;
} ucsv_ctx_t;


ucsv_token_t ucsv_parser_char(ucsv_ctx_t *ctx, int c);
void ucsv_parser_uninit(ucsv_ctx_t *ctx);


void ucsv_print_cell(ucsv_ctx_t *ctx, FILE *f, const char *str, int is_first_in_line);
void ucsv_print_endline(FILE *f);

#endif
