# Benchmarking

tiup bench has been **moved** to https://github.com/PingCAP-QE/tiup-bench

To facilitate this, TiUP has integrated the bench component, which currently provides two workloads for pressure testing: tpcc and tpch, with the following command parameters:

```bash
[user@localhost ~]# tiup bench
Starting component `bench`: /Users/joshua/.tiup/components/bench/v0.0.1/bench 
Benchmark database with different workloads

Usage:
  tiup bench [command]

Available Commands:
  help        Help about any command
  tpcc        TPC-C workload
  tpch        TPC-H workload

Flags:
      --count int           Total execution count, 0 means infinite
  -D, --db string           Database name (default "test")
  -d, --driver string       Database driver: mysql
      --dropdata            Cleanup data before prepare
  -h, --help                help for /Users/joshua/.tiup/components/bench/v0.0.1/bench
  -H, --host string         Database host (default "127.0.0.1")
      --ignore-error        Ignore error when running workload
      --interval duration   Output interval time (default 10s)
      --isolation int       Isolation Level 0: Default, 1: ReadUncommitted,
                            2: ReadCommitted, 3: WriteCommitted, 4: RepeatableRead,
                            5: Snapshot, 6: Serializable, 7: Linerizable
      --max-procs int       runtime.GOMAXPROCS
  -p, --password string     Database password
  -P, --port int            Database port (default 4000)
      --pprof string        Address of pprof endpoint
      --silence             Don't print error when running workload
      --summary             Print summary TPM only, or also print current TPM when running workload
  -T, --threads int         Thread concurrency (default 16)
      --time duration       Total execution time (default 2562047h47m16.854775807s)
  -U, --user string         Database user (default "root")
```

## TPC-C

The commands and parameters of TPC-C are as follows:

```bash
Available Commands:
  check       check for data consistency
  cleanup     clear data
  prepare     prepare data
  run         run benchmark

Flags:
      --check-all        run all consistency checks
  -h, --help             tpcc help information
      --output string    directory where csv file is generated when data is prepared
      --parts int        number of partition repositories (default 1)
      --tables string    specifies the tables used to generate the file, multiple tables can be split, only valid if output is set. All tables are generated by default
      --warehouses int   number of repositories (default 10)
```

### Example

1.  Create 4 repositories using 4 partitions with hash

```shell
tiup bench tpcc --warehouses 4 --parts 4 prepare
```

2. Running TPC-C benchmark

```shell
tiup bench tpcc --warehouses 4 run
```

3. Cleanup data

```shell
tiup bench tpcc --warehouses 4 cleanup
```

4. Checking consistency

```shell
tiup bench tpcc --warehouses 4 check
```

5. Generating csv files

```shell
tiup bench tpcc --warehouses 4 prepare --output data
```

6. Generate csv files for specified tables

```shell
tiup bench tpcc --warehouses 4 prepare --output data --tables history,orders
```

7. Turn on pprof

```shell
tiup bench tpcc --warehouses 4 prepare --output data --pprof :10111
```

## TPC-H

The commands and parameters of TPC-C are as follows:

```bash
Available Commands:
  cleanup     cleanup data
  prepare     prepare data
  run         run benchmark

Flags:
      --check            checks the output data, only valid if the scale factor is 1
  -h, --help             tpch help information
      --queries string   All query statements (default "q1,q2,q3,q4,q5,q6,q7,q8,q9,q10,q11,q12,q13,q14,q15,q16,q17,q18,q19,q20,q21,q22")
      --sf int           scale factor
```

## Example

1. Data preparation

```shell
# Prepare data with scale factor 1
tiup bench tpch --sf=1 prepare
# Or prepare data with scale factor 1, create tiflash replica, and analyze table after data loaded
tiup bench tpch --sf=1 --analyze --tiflash prepare
```

2. Benchmarking and checking results

```shell
tiup bench tpch --sf=1 --check=true run
```

3. Benchmarking without checking results

```shell
tiup bench tpch --sf=1 run
```

4. Cleanup

```shell
tiup bench tpch cleanup
```
