/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-track.h,v 1.14 2000/03/19 23:48:47 rich Exp $
 */

#ifndef __xracer_track_h__
#define __xracer_track_h__

#include <GL/gl.h>

#include "xracer-player.h"

/* XXX Obsolete - do not use. */
struct xrFace
{
  /* Coefficients of plane of the face itself. */
  GLfloat faceplane[4];

  /* The four planes which surround the face. */
  GLfloat planes[4][4];

  /* Index of the four vertices around the face. The actual vertices
   * are stored in the face_vertices[] array.
   */
  int vertices[4];
};

/* XXX Obsolete - do not use. */
struct xrSegmentFaces
{
  int nr_faces;
  int *faces;
};

/* This structure is used to describe the six planes which
 * surround each track face.
 */
struct xrTrackFace
{
  GLfloat face_plane_coefficient[4];
  GLfloat plane_coefficient[6][4];
};

/* This structure is used to describe a single enterplane. */
struct xrTrackEnterPlane
{
  GLfloat plane_coefficient[4];
};

/* This structure is used to describe the simple splitting
 * BSP which is used to determine which face(s) have influence
 * over which point.
 */
struct xrTrackBSPNode
{
  enum { nodetype_terminal, nodetype_interior } type;
  union {
    struct {			/* For terminal nodes. */
      int *faces;		/* List of faces. */
      int nr_faces;		/* Number of faces. */
    } t;
    struct {			/* For interior nodes. */
      struct xrTrackBSPNode *subtree0; /* Left if split axis == 'y' */
				       /* Below if split axis == 'x' */
      struct xrTrackBSPNode *subtree1; /* Right if split axis == 'y' */
				       /* Above if split axis == 'x' */
      GLfloat split;		/* Splitting line. */
      char split_axis;		/* Either 'x' or 'y'. */
    } i;
  } u;
};

struct xrTrackControl
{
  const char *name;

  /* These functions are called after the track has been loaded
   * and before the track has been unloaded respectively.
   */
  int (*load) (void);
  int (*unload) (void);

  /* These functions are called just before the game starts and
   * just after the game ends respectively.
   */
  int (*start_game) (void);
  int (*end_game) (void);

  /* Return the pilot starting position, rotation and segment number. */
  void (*get_pilot_start_position) (GLfloat *posn_rtn);
  void (*get_pilot_start_rotation) (GLfloat *rot_rtn);
  int (*get_pilot_start_segment) (void);

  /* Inspect the list of faces. */
  const struct xrTrackFace *(*get_face) (int face_num);
  int (*get_nr_faces) (void);

  /* Inspect the list of enterplanes. */
  const struct xrTrackEnterPlane *(*get_enterplane) (int enterplane_num);
  int (*get_nr_enterplanes) (void);

  /* Given a pilot position, return the list of faces which influence
   * this point. The list returned can (and probably should) be a
   * pointer to a static array so that there are no issues with
   * allocating and deallocating memory regions.
   */
  int *(*map_point_to_faces) (const GLfloat *point, int seg);

  void (*display) (const struct xrPlayer *player);
  void (*display_precipitation) (const struct xrPlayer *player);

  /* These are some internal fields used by the game engine to
   * store things when the track has been loaded into memory.
   */
  void *_lib;
};

/* The currently loaded track (or NULL if no track is ``current''). */
extern struct xrTrackControl *xrTrack;

/* Load a track by name from the tracks/ directory. */
extern void *xrTrackLoadByName (const char *name);

/* Load a track by filename. */
extern void *xrTrackLoadByFilename (const char *filename);

/* Unload a track. */
extern void xrTrackUnload (void *track);

/* Make a particular track the current track.
 * NOTE: If there is already a current track, then that track will be
 * *unloaded* by calling this function.
 */
extern void xrTrackMakeCurrent (void *track);

#endif /* __xracer_track_h__ */
