/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionUtils {
    private static final Log LOG = LogFactory.getLog(VersionUtils.class);

    private VersionUtils() {
    }

    public static String getImplementationVersion(Class<?> clazz) {
        String version;
        try {
            String classContainer = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            URL manifestUrl = new URL("jar:" + classContainer + "!/" + "META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestUrl.openStream());
            Attributes attributes = manifest.getMainAttributes();
            version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            version = "UNKNOWN";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Attributes.Name.IMPLEMENTATION_VERSION + ": " + version));
        }
        return StringUtils.defaultString(version);
    }
}

