/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.ColumnInformation;
import org.mariadb.jdbc.internal.common.queryresults.ColumnFlags;

public class MySQLResultSetMetaData
implements ResultSetMetaData {
    private ColumnInformation[] fieldPackets;
    private int datatypeMappingflags;
    static final String byteArrayClassName = "[B";

    public MySQLResultSetMetaData(ColumnInformation[] fieldPackets, int datatypeMappingFlags) {
        this.fieldPackets = fieldPackets;
        this.datatypeMappingflags = datatypeMappingFlags;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fieldPackets.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumnInformation(column).getFlags().contains((Object)ColumnFlags.AUTO_INCREMENT);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumnInformation(column).getFlags().contains((Object)ColumnFlags.BINARY_COLLATION);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (this.getColumnInformation(column).getFlags().contains((Object)ColumnFlags.NOT_NULL)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInformation(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return (int)this.getColumnInformation(column).getLength();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInformation(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String s = this.getColumnInformation(column).getOriginalName();
        if ("".equals(s)) {
            s = this.getColumnLabel(column);
        }
        return s;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnInformation(column).getDb();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return (int)this.getColumnInformation(column).getLength();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInformation(column).getDecimals();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumnInformation(column).getTable();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        switch (ci.getType().getType()) {
            case BIT: {
                if (ci.getLength() == 1L) {
                    return -7;
                }
                return -3;
            }
            case TINYINT: {
                if (ci.getLength() == 1L && (this.datatypeMappingflags & 1) != 0) {
                    return -7;
                }
                return -6;
            }
            case YEAR: {
                if ((this.datatypeMappingflags & 2) != 0) {
                    return 91;
                }
                return 5;
            }
            case SMALLINT: {
                if (!ci.isSigned()) {
                    return 4;
                }
                return 5;
            }
            case INTEGER: {
                if (!ci.isSigned()) {
                    return -5;
                }
                return 4;
            }
            case BLOB: {
                if (ci.getLength() < 0L || ci.getLength() > 0xFFFFFFL) {
                    return -4;
                }
                return -3;
            }
            case VARCHAR: {
                if (ci.isBinary()) {
                    return -3;
                }
                if (ci.getLength() < 0L) {
                    return -1;
                }
                return 12;
            }
            case CHAR: {
                if (ci.isBinary()) {
                    return -2;
                }
                return 1;
            }
        }
        return ci.getType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        switch (ci.getType().getType()) {
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: {
                if (!ci.isSigned()) {
                    return ci.getType().getTypeName() + " UNSIGNED";
                }
                return ci.getType().getTypeName();
            }
            case BLOB: {
                if (ci.getLength() < 0L) {
                    return "LONGBLOB";
                }
                if (ci.getLength() <= 255L) {
                    return "TINYBLOB";
                }
                if (ci.getLength() <= 65535L) {
                    return "BLOB";
                }
                if (ci.getLength() <= 0xFFFFFFL) {
                    return "MEDIUMBLOB";
                }
                return "LONGBLOB";
            }
            case VARCHAR: {
                if (ci.isBinary()) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case CHAR: {
                if (ci.isBinary()) {
                    return "BINARY";
                }
                return "CHAR";
            }
        }
        return ci.getType().getTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        switch (ci.getType().getType()) {
            case OLDDECIMAL: {
                return BigDecimal.class.getName();
            }
            case TINYINT: {
                if (ci.getLength() == 1L && (this.datatypeMappingflags & 1) != 0) {
                    return Boolean.class.getName();
                }
                return Integer.class.getName();
            }
            case SMALLINT: {
                return Integer.class.getName();
            }
            case INTEGER: {
                if (ci.isSigned()) {
                    return Integer.class.getName();
                }
                return Long.class.getName();
            }
            case FLOAT: {
                return Float.class.getName();
            }
            case DOUBLE: {
                return Double.class.getName();
            }
            case NULL: {
                return null;
            }
            case TIMESTAMP: {
                return Timestamp.class.getName();
            }
            case BIGINT: {
                return ci.isSigned() ? Long.class.getName() : BigInteger.class.getName();
            }
            case MEDIUMINT: {
                return Integer.class.getName();
            }
            case DATETIME: {
                return Timestamp.class.getName();
            }
            case DATE: {
                return Date.class.getName();
            }
            case TIME: {
                return Time.class.getName();
            }
            case YEAR: {
                if ((this.datatypeMappingflags & 2) != 0) {
                    return Date.class.getName();
                }
                return Short.class.getName();
            }
            case BIT: {
                if (ci.getLength() == 1L) {
                    return Boolean.class.getName();
                }
                return byteArrayClassName;
            }
            case VARCHAR: {
                if (ci.isBinary()) {
                    return byteArrayClassName;
                }
                return String.class.getName();
            }
            case DECIMAL: {
                return BigDecimal.class.getName();
            }
            case BLOB: {
                return byteArrayClassName;
            }
            case CLOB: {
                return String.class.getName();
            }
            case CHAR: {
                if (ci.isBinary()) {
                    return byteArrayClassName;
                }
                return String.class.getName();
            }
        }
        return byteArrayClassName;
    }

    private ColumnInformation getColumnInformation(int column) throws SQLException {
        if (column >= 1 && column <= this.fieldPackets.length) {
            return this.fieldPackets[column - 1];
        }
        throw SQLExceptionMapper.getSQLException("No such column");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

