/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLResultSet;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.Protocol;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public class MySQLStatement
implements Statement {
    private final MySQLProtocol protocol;
    protected MySQLConnection connection;
    private QueryResult queryResult;
    private boolean warningsCleared;
    private int queryTimeout;
    private boolean escapeProcessing;
    private int fetchSize;
    private int maxRows;
    boolean isClosed;
    private static volatile Timer timer;
    private TimerTask timerTask;
    private boolean isTimedout;
    Queue<Object> cachedResultSets;

    public boolean isStreaming() {
        return this.fetchSize == Integer.MIN_VALUE;
    }

    public MySQLStatement(MySQLConnection connection) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.escapeProcessing = true;
        this.cachedResultSets = new LinkedList<Object>();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Timer getTimer() {
        Timer result = timer;
        if (result != null) return result;
        Class<MySQLStatement> clazz = MySQLStatement.class;
        synchronized (MySQLStatement.class) {
            result = timer;
            if (result != null) return result;
            timer = result = new Timer(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private void setTimerTask() {
        assert (this.timerTask == null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MySQLStatement.this.isTimedout = true;
                    MySQLStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        MySQLStatement.getTimer().schedule(this.timerTask, this.queryTimeout * 1000);
    }

    private void checkReconnect() throws SQLException {
        if (this.protocol.shouldReconnect()) {
            try {
                this.protocol.connect();
            }
            catch (QueryException qe) {
                SQLExceptionMapper.throwException(qe, this.connection, this);
            }
        } else if (this.protocol.shouldTryFailback()) {
            try {
                this.protocol.reconnectToMaster();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void executeQueryProlog() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.checkReconnect();
        if (this.protocol.isClosed()) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (this.protocol.hasUnreadData()) {
            throw new SQLException("There is an open result set on the current connection, which must be closed prior to executing a query");
        }
        if (this.protocol.hasMoreResults()) {
            while (this.getMoreResults(true)) {
            }
        }
        this.cachedResultSets.clear();
        MySQLConnection conn = (MySQLConnection)this.getConnection();
        conn.reenableWarnings();
        try {
            this.protocol.setMaxRows(this.maxRows);
        }
        catch (QueryException qe) {
            SQLExceptionMapper.throwException(qe, this.connection, this);
        }
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    private void cacheMoreResults() {
        if (this.isStreaming()) {
            return;
        }
        QueryResult saveResult = this.queryResult;
        try {
            while (this.getMoreResults(false)) {
                this.cachedResultSets.add(this.queryResult);
            }
        }
        catch (SQLException e) {
            this.cachedResultSets.add(e);
        }
        this.queryResult = saveResult;
    }

    private void executeQueryEpilog(QueryException e, Query query) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            e = new QueryException("Query timed out", 1317, "JZ0002", e);
        }
        if (e == null) {
            return;
        }
        if (this.protocol.getInfo().getProperty("dumpQueriesOnException", "false").equalsIgnoreCase("true") || e.getErrorCode() == 1064) {
            String queryString = query.toString();
            if (queryString.length() > 4096) {
                queryString = queryString.substring(0, 4096);
            }
            e.setMessage(e.getMessage() + "\nQuery is:\n" + queryString);
        }
        SQLExceptionMapper.throwException(e, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(Query query) throws SQLException {
        MySQLProtocol mySQLProtocol = this.protocol;
        synchronized (mySQLProtocol) {
            boolean bl;
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                this.queryResult = this.protocol.executeQuery(query, this.isStreaming());
                this.cacheMoreResults();
                bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception, query);
                    throw throwable;
                }
                this.executeQueryEpilog(exception, query);
                return bl2;
            }
            this.executeQueryEpilog(exception, query);
            return bl;
        }
    }

    protected ResultSet executeQuery(Query query) throws SQLException {
        if (this.execute(query)) {
            return new MySQLResultSet(this.queryResult, this, this.protocol);
        }
        return MySQLResultSet.EMPTY;
    }

    protected int executeUpdate(Query query) throws SQLException {
        if (this.execute(query)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    private Query stringToQuery(String queryString) throws SQLException {
        if (this.escapeProcessing) {
            queryString = Utils.nativeSQL(queryString, this.connection.noBackslashEscapes);
        }
        return new MySQLQuery(queryString);
    }

    @Override
    public boolean execute(String queryString) throws SQLException {
        return this.execute(this.stringToQuery(queryString));
    }

    @Override
    public int executeUpdate(String queryString) throws SQLException {
        return this.executeUpdate(this.stringToQuery(queryString));
    }

    @Override
    public ResultSet executeQuery(String queryString) throws SQLException {
        return this.executeQuery(this.stringToQuery(queryString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
            this.queryResult = null;
        }
        this.cachedResultSets.clear();
        if (this.isStreaming()) {
            MySQLProtocol mySQLProtocol = this.protocol;
            synchronized (mySQLProtocol) {
                while (this.getMoreResults(true)) {
                }
            }
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows is negative");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
            return MySQLResultSet.createGeneratedKeysResultSet(((ModifyQueryResult)this.queryResult).getInsertId(), this.protocol);
        }
        return MySQLResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return null;
        }
        return new MySQLResultSet(this.queryResult, this, this.protocol);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return -1;
        }
        return (int)((ModifyQueryResult)this.queryResult).getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMoreResults(boolean streaming) throws SQLException {
        try {
            MySQLProtocol mySQLProtocol = this.protocol;
            synchronized (mySQLProtocol) {
                if (this.queryResult != null) {
                    this.queryResult.close();
                }
                this.queryResult = this.protocol.getMoreResults(streaming);
                if (this.queryResult == null) {
                    return false;
                }
                this.warningsCleared = false;
                this.connection.reenableWarnings();
                return true;
            }
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
            return false;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (!this.isStreaming()) {
            if (this.cachedResultSets.isEmpty()) {
                this.queryResult = null;
                return false;
            }
            Object o = this.cachedResultSets.remove();
            if (o instanceof SQLException) {
                throw (SQLException)o;
            }
            this.queryResult = (QueryResult)o;
            return true;
        }
        return this.getMoreResults(false);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.protocol.addToBatch(new MySQLQuery(sql));
    }

    public void addBatch(byte[] sql) throws SQLException {
        this.protocol.addToBatch(new MySQLQuery(sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.protocol.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            List<QueryResult> queryRes = this.protocol.executeBatch();
            int[] retVals = new int[queryRes.size()];
            int i = 0;
            for (QueryResult qr : queryRes) {
                if (qr.getResultSetType() == ResultSetType.MODIFY) {
                    retVals[i++] = (int)((ModifyQueryResult)qr).getUpdateCount();
                    continue;
                }
                retVals[i++] = -2;
            }
            return retVals;
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
            return null;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected QueryResult getQueryResult() {
        return this.queryResult;
    }

    protected void setQueryResult(QueryResult result) {
        this.queryResult = result;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

