/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log log = LogFactory.getLog(StreamUtil.class);
    private static final int READ_STREAM_BUFFER_SIZE = 10000;

    public static byte[] readData(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[10000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while reading data.", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        return baos.toByteArray();
    }

    public static byte[] readData(InputStream is, int size) {
        if (is == null) {
            return null;
        }
        try {
            byte[] data = new byte[size];
            int offset = 0;
            while (size > 0) {
                int read = is.read(data, offset, size);
                if (read < 0) {
                    throw new JSException("jsexception.input.stream.exhausted", new Object[]{new Integer(size)});
                }
                offset += read;
                size -= read;
            }
            return data;
        }
        catch (IOException e) {
            log.error((Object)"Error while reading data.", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public static byte[] readData(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return StreamUtil.readData(blob.getBinaryStream());
        }
        catch (SQLException e) {
            log.error((Object)"Error while reading blob data", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public static void pipeData(InputStream is, OutputStream os) throws IOException {
        if (is == null) {
            return;
        }
        byte[] bytes = new byte[10000];
        int ln = 0;
        while ((ln = is.read(bytes)) > 0) {
            os.write(bytes, 0, ln);
        }
    }

    public static void writeObjectByteData(ObjectOutputStream objectStream, InputStream data) throws IOException {
        StreamUtil.pipeData(data, objectStream);
    }

    public static void readObjectByteData(ObjectInputStream objectStream, int size, OutputStream outStream) throws IOException {
        byte[] buffer = new byte[10000];
        while (size > 0) {
            int read = buffer.length;
            if (read > size) {
                read = size;
            }
            objectStream.readFully(buffer, 0, read);
            outStream.write(buffer, 0, read);
            size -= read;
        }
    }

    public static String uncompressToString(byte[] compressed) throws IOException {
        String line;
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        GZIPInputStream gzis = new GZIPInputStream(bais);
        BufferedReader br = new BufferedReader(new InputStreamReader(gzis));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static byte[] compress(String string) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        OutputStreamWriter osw = new OutputStreamWriter(gzos);
        osw.write(string);
        osw.flush();
        osw.close();
        return baos.toByteArray();
    }

    public static Object uncompressObject(byte[] compressed) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        GZIPInputStream gzis = new GZIPInputStream(bais);
        ObjectInputStream ois = new ObjectInputStream(gzis);
        return ois.readObject();
    }

    public static byte[] compress(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        ObjectOutputStream oos = new ObjectOutputStream(gzos);
        oos.writeObject(object);
        oos.flush();
        oos.close();
        return baos.toByteArray();
    }
}

