/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import com.jaspersoft.jasperserver.api.SessionAttribMissingException;
import com.jaspersoft.jasperserver.core.util.MissingObject;
import com.jaspersoft.jasperserver.core.util.TolerantObjectWrapper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.log4j.Logger;

public class TolerantHttpSession
implements HttpSession {
    protected final Logger log = Logger.getLogger(this.getClass());
    private HttpSession httpSession;

    public TolerantHttpSession(HttpSession obj) {
        this.httpSession = obj;
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.httpSession.getServletContext();
    }

    public void setMaxInactiveInterval(int i) {
        this.httpSession.setMaxInactiveInterval(i);
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.httpSession.getSessionContext();
    }

    public Object getAttribute(String name) {
        Object obj = this.httpSession.getAttribute(name);
        if (obj instanceof TolerantObjectWrapper) {
            Object obw = ((TolerantObjectWrapper)obj).getObject();
            if (obw instanceof MissingObject) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Missing value found on session for key " + name));
                }
                this.removeAllMissingObjects();
                throw new SessionAttribMissingException("cluster.exception.session.attribute.missing");
            }
            return obw;
        }
        return obj;
    }

    private List<String> removeAllMissingObjects() {
        ArrayList<String> missingAttributeNames = new ArrayList<String>();
        Enumeration sessionAttributes = this.httpSession.getAttributeNames();
        while (sessionAttributes.hasMoreElements()) {
            String attributeName = (String)sessionAttributes.nextElement();
            Object obj = this.httpSession.getAttribute(attributeName);
            if (!(obj instanceof TolerantObjectWrapper) || !(((TolerantObjectWrapper)obj).getObject() instanceof MissingObject)) continue;
            missingAttributeNames.add(attributeName);
            this.httpSession.removeAttribute(attributeName);
        }
        return missingAttributeNames;
    }

    public Object getValue(String s) {
        return this.getAttribute(s);
    }

    public Enumeration getAttributeNames() {
        return this.httpSession.getAttributeNames();
    }

    public String[] getValueNames() {
        return this.httpSession.getValueNames();
    }

    public void setAttribute(String name, Object obj) {
        TolerantObjectWrapper ObjWrap = new TolerantObjectWrapper(obj);
        this.httpSession.setAttribute(name, (Object)ObjWrap);
    }

    public void putValue(String name, Object obj) {
        this.setAttribute(name, obj);
    }

    public void removeAttribute(String s) {
        this.httpSession.removeAttribute(s);
    }

    public void removeValue(String s) {
        this.httpSession.removeValue(s);
    }

    public void invalidate() {
        this.httpSession.invalidate();
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }
}

