/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectResolver;
import org.hibernate.dialect.resolver.DialectResolverSet;
import org.hibernate.dialect.resolver.StandardDialectResolver;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)DialectFactory.class);
    private static DialectResolverSet DIALECT_RESOLVERS = new DialectResolverSet();

    static void registerDialectResolver(String resolverName) {
        try {
            DialectResolver resolver = (DialectResolver)ReflectHelper.classForName(resolverName).newInstance();
            DIALECT_RESOLVERS.addResolverAtFirst(resolver);
        }
        catch (ClassNotFoundException cnfe) {
            log.warn("Dialect resolver class not found: " + resolverName);
        }
        catch (Exception e) {
            log.warn("Could not instantiate dialect resolver class", (Throwable)e);
        }
    }

    public static Dialect buildDialect(Properties properties, Connection connection) throws HibernateException {
        String dialectName = properties.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return DialectFactory.determineDialect(connection);
        }
        return DialectFactory.constructDialect(dialectName);
    }

    public static Dialect buildDialect(Properties properties) {
        String dialectName = properties.getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("'hibernate.dialect' must be set when no Connection avalable");
        }
        return DialectFactory.constructDialect(dialectName);
    }

    private static Dialect determineDialect(Connection connection) {
        if (connection == null) {
            throw new HibernateException("Connection cannot be null when 'hibernate.dialect' not set");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Dialect dialect = DIALECT_RESOLVERS.resolveDialect(databaseMetaData);
            if (dialect == null) {
                throw new HibernateException("Unable to determine Dialect to use [name=" + databaseMetaData.getDatabaseProductName() + ", majorVersion=" + databaseMetaData.getDatabaseMajorVersion() + "]; user must register resolver or explicitly set 'hibernate.dialect'");
            }
            return dialect;
        }
        catch (SQLException sqlException) {
            throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", sqlException);
        }
    }

    public static Dialect constructDialect(String dialectName) {
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName, cnfe);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    static {
        DIALECT_RESOLVERS.addResolver(new StandardDialectResolver());
        String userSpecifedResolverSetting = Environment.getProperties().getProperty("hibernate.dialect_resolvers");
        if (userSpecifedResolverSetting != null) {
            String[] userSpecifedResolvers = userSpecifedResolverSetting.split("\\s+");
            for (int i = 0; i < userSpecifedResolvers.length; ++i) {
                DialectFactory.registerDialectResolver(userSpecifedResolvers[i]);
            }
        }
    }
}

