/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;

public class ReportExecutionHyperlinkProducer
implements JRHyperlinkProducer {
    public String getHyperlink(JRPrintHyperlink hyperlink) {
        StringBuffer sb = new StringBuffer();
        sb.append("executeReport.jsp?");
        JRPrintHyperlinkParameters parameters = hyperlink.getHyperlinkParameters();
        if (parameters != null) {
            for (JRPrintHyperlinkParameter parameter : parameters.getParameters()) {
                if (parameter.getName().equals("_report")) {
                    this.appendParameter(sb, "uri", (String)parameter.getValue());
                    continue;
                }
                if (parameter.getName().equals("_output")) {
                    this.appendParameter(sb, "format", (String)parameter.getValue());
                    continue;
                }
                this.appendParameter(sb, parameter);
            }
        }
        return sb.toString();
    }

    protected void appendParameter(StringBuffer sb, JRPrintHyperlinkParameter parameter) {
        String name = parameter.getName();
        String valueClassName = parameter.getValueClass();
        Class valueClass = this.loadClass(valueClassName);
        Object value = parameter.getValue();
        if (valueClass.equals(String.class)) {
            this.appendParameter(sb, name, (String)value);
        } else if (valueClass.equals(Boolean.class)) {
            if (value != null && ((Boolean)value).booleanValue()) {
                this.appendParameter(sb, name, "true");
            }
        } else if (Number.class.isAssignableFrom(valueClass)) {
            if (value != null) {
                this.appendParameter(sb, name, value.toString());
            }
        } else if (Date.class.isAssignableFrom(valueClass) && value != null) {
            this.appendParameter(sb, name, Long.toString(((Date)value).getTime()));
        }
    }

    protected Class loadClass(String valueClassName) {
        try {
            return Class.forName(valueClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void appendParameter(StringBuffer sb, String name, String value) {
        if (!sb.substring(sb.length() - 1, sb.length()).equals("?")) {
            sb.append('&');
        }
        sb.append(this.encode(name));
        if (value != null) {
            sb.append('=');
            sb.append(this.encode(value));
        }
    }

    protected String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

