/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample.controller;

import com.jaspersoft.jasperserver.sample.controller.WSServlet;
import com.jaspersoft.jasperserver.sample.controller.vo.RoleWithAssignedMarkVO;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import com.jaspersoft.jasperserver.ws.client.authority.UserAndRoleManagement;
import com.jaspersoft.jasperserver.ws.client.controller.WSClientManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

public class UserServlet
extends WSServlet {
    public static final String ATTR_USERS = "users";
    public static final String ATTR_USER = "user";
    public static final String ATTR_ROLES = "roles";
    public static final String ATTR_SEARCH_NAME = "searchName";
    public static final String ATTR_VIEW_MODE = "viewMode";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_SEARCH_NAME = "searchName";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_PUT = "put";
    public static final String ACTION_DELETE = "delete";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_TENANT_ID = "tenantId";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_FULLNAME = "fullName";
    public static final String PARAM_EMAILADDRESS = "emailAddress";
    public static final String PARAM_ENABLED = "enabled";
    public static final String PARAM_ROLE_PREFIX = "role_";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter(PARAM_ACTION);
        try {
            UserAndRoleManagement userAndRoleManagement = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request));
            if (ACTION_EDIT.equalsIgnoreCase(action)) {
                WSUser user = this.getEditUser(request, userAndRoleManagement);
                List<RoleWithAssignedMarkVO> rolesWithAssignedMark = this.getEditRolesAssignedMarks(request, userAndRoleManagement, user);
                if (user == null) {
                    response.sendRedirect(ATTR_USER);
                } else {
                    request.setAttribute(ATTR_USER, (Object)user);
                    request.setAttribute(ATTR_ROLES, rolesWithAssignedMark);
                    this.forward("authority/user.jsp", request, response);
                }
            } else if (ACTION_PUT.equalsIgnoreCase(action)) {
                this.putUser(request, userAndRoleManagement);
                response.sendRedirect(ATTR_USER);
            }
            if (ACTION_DELETE.equalsIgnoreCase(action)) {
                this.deleteUser(request, userAndRoleManagement);
                response.sendRedirect(ATTR_USER);
            }
        }
        catch (Exception e) {
            this.forwardError(e, request, response);
        }
    }

    protected WSUser getEditUser(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        String username = request.getParameter(PARAM_USERNAME);
        WSUser user = username != null && username.length() > 0 ? this.getUser(request, username, userAndRoleManagement) : new WSUser();
        return user;
    }

    private List<RoleWithAssignedMarkVO> getEditRolesAssignedMarks(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement, WSUser user) throws RemoteException {
        String username = request.getParameter(PARAM_USERNAME);
        List<RoleWithAssignedMarkVO> rolesWithAssignedMark = username != null && username.length() > 0 ? this.getRolesWithAssignedMark(Arrays.asList(this.getAllRoles(request, userAndRoleManagement)), Arrays.asList(user.getRoles())) : this.getRolesWithAssignedMark(Arrays.asList(this.getAllRoles(request, userAndRoleManagement)), Collections.EMPTY_LIST);
        return rolesWithAssignedMark;
    }

    protected void deleteUser(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        String username = request.getParameter(PARAM_USERNAME);
        WSUser user = new WSUser();
        user.setUsername(username);
        userAndRoleManagement.deleteUser(user);
    }

    protected void putUser(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        String username = request.getParameter(PARAM_USERNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        String fullName = request.getParameter(PARAM_FULLNAME);
        String emailAddress = request.getParameter(PARAM_EMAILADDRESS);
        String enabled = request.getParameter(PARAM_ENABLED);
        WSRole[] assignedRoles = this.getAssignedRoles(request, userAndRoleManagement);
        WSUser user = new WSUser();
        user.setUsername(username);
        user.setPassword(password);
        user.setFullName(fullName);
        user.setEmailAddress(emailAddress);
        user.setEnabled(Boolean.valueOf(enabled.equals("on")));
        user.setPreviousPasswordChangeTime(new Date());
        user.setRoles(assignedRoles);
        userAndRoleManagement.putUser(user);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String searchName = request.getParameter("searchName");
        searchName = searchName != null ? searchName : "";
        try {
            UserAndRoleManagement userAndRoleManagement = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request));
            WSUserSearchCriteria searchCriteria = this.createSearchCriteria(request, searchName);
            WSUser[] users = userAndRoleManagement.findUsers(searchCriteria);
            request.setAttribute("searchName", (Object)searchName);
            request.setAttribute(ATTR_USERS, (Object)users);
            request.setAttribute(ATTR_VIEW_MODE, (Object)ATTR_USER);
            this.forward("authority/list.jsp", request, response);
        }
        catch (Exception e) {
            this.forwardError(e, request, response);
        }
    }

    protected WSUserSearchCriteria createSearchCriteria(HttpServletRequest request, String searchName) throws RemoteException, ServiceException {
        WSUserSearchCriteria searchCriteria = new WSUserSearchCriteria();
        searchCriteria.setName(searchName);
        searchCriteria.setTenantId(null);
        searchCriteria.setMaxRecords(0);
        searchCriteria.setIncludeSubOrgs(Boolean.TRUE);
        searchCriteria.setRequiredRoles(null);
        return searchCriteria;
    }

    protected WSUser getUser(HttpServletRequest request, String username, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        WSUser[] users;
        WSUserSearchCriteria searchCriteria = new WSUserSearchCriteria();
        searchCriteria.setName(username);
        searchCriteria.setTenantId(null);
        searchCriteria.setMaxRecords(0);
        searchCriteria.setIncludeSubOrgs(Boolean.TRUE);
        searchCriteria.setRequiredRoles(null);
        for (WSUser user : users = userAndRoleManagement.findUsers(searchCriteria)) {
            if (!username.equals(user.getUsername())) continue;
            return user;
        }
        return null;
    }

    protected WSRole[] getAssignedRoles(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        ArrayList<WSRole> roles = new ArrayList<WSRole>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PARAM_ROLE_PREFIX)) continue;
            String name = key.substring(PARAM_ROLE_PREFIX.length());
            WSRole[] wsRole = userAndRoleManagement.findRoles(new WSRoleSearchCriteria(name, null, Boolean.valueOf(true), 0));
            if (wsRole == null || wsRole.length == 0 || wsRole.length > 1) {
                throw new RuntimeException("Problems to find role with role name '" + name + "'");
            }
            roles.add(wsRole[0]);
        }
        return roles.toArray(new WSRole[roles.size()]);
    }

    protected WSRole[] getAllRoles(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        WSRoleSearchCriteria searchCriteria = new WSRoleSearchCriteria("", null, Boolean.valueOf(true), 0);
        return userAndRoleManagement.findRoles(searchCriteria);
    }

    protected List<RoleWithAssignedMarkVO> getRolesWithAssignedMark(Collection<WSRole> allRoles, Collection<WSRole> assignedRoles) {
        ArrayList<RoleWithAssignedMarkVO> rolesWithAssignedMark = new ArrayList<RoleWithAssignedMarkVO>(allRoles.size());
        for (WSRole role : allRoles) {
            RoleWithAssignedMarkVO roleWithAssignedMarkVO = new RoleWithAssignedMarkVO();
            roleWithAssignedMarkVO.setRole(role);
            roleWithAssignedMarkVO.setAssigned(assignedRoles.contains(role));
            rolesWithAssignedMark.add(roleWithAssignedMarkVO);
        }
        return rolesWithAssignedMark;
    }
}

