/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.BaseExportImportCommand;
import com.jaspersoft.jasperserver.export.CommandBean;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class RemoveDuplicatedDisplayName
implements CommandBean {
    private String rootUri = null;
    private RepositoryService repository;
    protected static final CommandOut commandOut = CommandOut.getInstance();
    private static OutputStreamWriter osw;
    private static CharacterEncodingProvider encodingProvider;
    private static boolean updateRepo;
    protected static final BaseExportImportCommand.SpringResourceFactory classPathResourceFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Parameters params = null;
        boolean success = false;
        try {
            GenericApplicationContext ctx = new GenericApplicationContext();
            XmlBeanDefinitionReader configReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
            List resourceXML = RemoveDuplicatedDisplayName.getPaths(args[2]);
            if (args != null && args.length > 0) {
                for (int i = 0; i < resourceXML.size(); ++i) {
                    org.springframework.core.io.Resource resource = classPathResourceFactory.create((String)resourceXML.get(i));
                    configReader.loadBeanDefinitions(resource);
                }
            }
            ctx.refresh();
            if (args.length > 3 && "UPDATE".equals(args[3])) {
                updateRepo = true;
            }
            try {
                CommandBean commandBean = (CommandBean)ctx.getBean("removeDuplicateDisplayName", CommandBean.class);
                Charset encoding = Charset.forName(((RemoveDuplicatedDisplayName)commandBean).getEncodingProvider().getCharacterEncoding());
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream("remove_duplicated_display_name_report.txt"), encoding);
                commandBean.process(params);
            }
            finally {
                osw.close();
            }
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.exit(success ? 0 : -1);
    }

    public CharacterEncodingProvider getEncodingProvider() {
        return encodingProvider;
    }

    public void setEncodingProvider(CharacterEncodingProvider encodingProvider) {
        RemoveDuplicatedDisplayName.encodingProvider = encodingProvider;
    }

    private static List getPaths(String listOfXML) {
        ArrayList<Object> lst = new ArrayList<Object>();
        StringTokenizer str = new StringTokenizer(listOfXML, ",");
        while (str.hasMoreElements()) {
            lst.add(str.nextElement());
        }
        return lst;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public RemoveDuplicatedDisplayName() {
        this("/");
    }

    public RemoveDuplicatedDisplayName(String rtUri) {
        this.rootUri = rtUri;
        this.repository = new HibernateRepositoryServiceImpl();
    }

    public String getRootUri() {
        return this.rootUri;
    }

    public void setRootUri(String rootUri) {
        this.rootUri = rootUri;
    }

    @Override
    public void process(Parameters param) {
        this.remove(this.rootUri);
    }

    public boolean remove(String parentFolderUri) {
        List subFolders = this.repository.getSubFolders(null, parentFolderUri);
        this.cleanUpDisplayNames(parentFolderUri, subFolders);
        for (int i = 0; i < subFolders.size(); ++i) {
            this.remove(((Resource)subFolders.get(i)).getURIString());
        }
        return true;
    }

    private boolean cleanUpDisplayNames(String parentFolderUri, List subFolders) {
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolderUri));
        List resources = this.repository.loadResourcesList(null, criteria);
        ArrayList allObjects = new ArrayList();
        allObjects.addAll(subFolders);
        allObjects.addAll(resources);
        this.hashNames(allObjects);
        return true;
    }

    private boolean hashNames(List objects) {
        Hashtable ht = new Hashtable();
        for (int i = 0; i < objects.size(); ++i) {
            String curDisplayName = ((Resource)objects.get(i)).getLabel();
            if (!ht.containsKey(curDisplayName)) {
                ArrayList checkList = new ArrayList();
                checkList.add(objects.get(i));
                ht.put(curDisplayName, checkList);
                continue;
            }
            ((List)ht.get(curDisplayName)).add(objects.get(i));
        }
        this.updateDuplicateNames(ht);
        return true;
    }

    private boolean updateDuplicateNames(Hashtable ht) {
        Enumeration enu = ht.keys();
        while (enu.hasMoreElements()) {
            List valueList = (List)ht.get((String)enu.nextElement());
            if (valueList.size() <= 1) continue;
            int curValue = 2;
            for (int i = 1; i < valueList.size(); ++i) {
                try {
                    osw.write("\r\n");
                    osw.write("Parent Folder: " + ((Resource)valueList.get(i)).getParentURI());
                    osw.write("\r\n");
                    osw.write("Modified Object Name(ID): " + ((Resource)valueList.get(i)).getURIString());
                    osw.write("\r\n");
                    osw.write("Modified Object Old Display Name: " + ((Resource)valueList.get(i)).getLabel());
                    osw.write("\r\n");
                }
                catch (IOException e) {
                    // empty catch block
                }
                int newNumber = this.findUniqueDisplayNameNumber(ht, curValue, ((Resource)valueList.get(i)).getLabel());
                String newLabel = ((Resource)valueList.get(i)).getLabel() + " (" + newNumber + ")";
                ((Resource)valueList.get(i)).setLabel(newLabel);
                if (valueList.get(i) instanceof Folder) {
                    if (updateRepo) {
                        this.repository.saveFolder(null, (Folder)valueList.get(i));
                    }
                    try {
                        osw.write("Modified Object New Display Name: " + newLabel);
                        osw.write("\r\n");
                        osw.write("Modified Object Type: Folder");
                        osw.write("\r\n");
                        osw.write("\r\n");
                    }
                    catch (IOException e) {}
                } else {
                    if (updateRepo) {
                        Resource res = this.repository.getResource(null, ((Resource)valueList.get(i)).getURIString());
                        res.setLabel(newLabel);
                        this.repository.saveResource(null, res);
                    }
                    try {
                        osw.write("Modified Object New Display Name: " + newLabel);
                        osw.write("\r\n");
                        osw.write("Modified Object Type: " + ((Resource)valueList.get(i)).getResourceType());
                        osw.write("\r\n");
                        osw.write("\r\n");
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                curValue = newNumber + 1;
            }
        }
        return true;
    }

    private int findUniqueDisplayNameNumber(Hashtable ht, int appValue, String name) {
        String returnDisplayName = name;
        int tempValue = appValue;
        while (ht.containsKey(returnDisplayName + " (" + tempValue + ")")) {
            ++tempValue;
        }
        return tempValue;
    }

    static {
        updateRepo = false;
        classPathResourceFactory = new BaseExportImportCommand.SpringResourceFactory(){

            @Override
            public org.springframework.core.io.Resource create(String location) {
                commandOut.debug("Loading Spring configuration classpath resource " + location);
                return new ClassPathResource(location);
            }
        };
    }
}

