/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import java.util.HashMap;
import java.util.Map;

public class CustomDataSourceBean
extends ResourceBean {
    private String serviceClass;
    private Map propertyMap;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        CustomReportDataSource ds = (CustomReportDataSource)res;
        this.setServiceClass(ds.getServiceClass());
        Map dsProperties = ds.getPropertyMap();
        if (dsProperties == null) {
            this.setPropertyMap(new HashMap());
        } else {
            HashMap<String, String> copyDsPropertyMap = new HashMap<String, String>(dsProperties);
            String pwd = (String)copyDsPropertyMap.get("password");
            if (pwd != null && pwd.trim().length() > 0) {
                copyDsPropertyMap.put("password", "ENC<" + importExportCipher.encode(pwd) + ">");
            }
            this.setPropertyMap(copyDsPropertyMap);
        }
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        CustomReportDataSource ds = (CustomReportDataSource)res;
        ds.setServiceClass(this.getServiceClass());
        Map dsPropertyMap = this.getPropertyMap();
        if (dsPropertyMap == null) {
            ds.setPropertyMap(new HashMap());
        } else {
            HashMap<String, String> copyDsPropertyMap = new HashMap<String, String>(dsPropertyMap);
            String pwd = (String)copyDsPropertyMap.get("password");
            if (pwd != null && pwd.trim().length() > 0) {
                copyDsPropertyMap.put("password", pwd.startsWith("ENC<") && pwd.endsWith(">") ? importExportCipher.decode(pwd.replaceFirst("ENC<", "").replaceAll(">$", "")) : pwd);
            }
            ds.setPropertyMap(copyDsPropertyMap);
        }
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(Map propertyMap) {
        this.propertyMap = propertyMap;
    }
}

