/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;

public class FileResourceBean
extends ResourceBean {
    public static final String DATA_PROVIDER_ID = "fileResourceData";
    private String fileType;
    private String dataFile;
    private String referenceUri;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
        FileResource fileRes = (FileResource)res;
        this.setFileType(fileRes.getFileType());
        this.setDataFile(exportHandler.handleData(res, DATA_PROVIDER_ID));
        String reference = fileRes.getReferenceURI();
        this.setReferenceUri(reference);
        if (reference != null) {
            exportHandler.queueResource(reference);
        }
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        FileResource fileRes = (FileResource)res;
        fileRes.setFileType(this.getFileType());
        if (this.dataFile != null) {
            fileRes.setData(importHandler.handleData(this, this.dataFile, DATA_PROVIDER_ID));
        }
        if (this.referenceUri != null) {
            fileRes.setReferenceURI(importHandler.handleResource(this.referenceUri));
        }
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getReferenceUri() {
        return this.referenceUri;
    }

    public void setReferenceUri(String referenceUri) {
        this.referenceUri = referenceUri;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }
}

