/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;

public class OlapUnitBean
extends ResourceBean {
    public static final String DATA_PROVIDER_VIEW_OPTIONS = "olapUnitViewOptions";
    private String mdxQuery;
    private ResourceReferenceBean olapClientConnection;
    private String olapViewOptionsDataFile;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
        OlapUnit unit = (OlapUnit)res;
        this.setMdxQuery(unit.getMdxQuery());
        this.setOlapClientConnection(exportHandler.handleReference(unit.getOlapClientConnection()));
        this.setOlapViewOptionsDataFile(exportHandler.handleData((Resource)unit, DATA_PROVIDER_VIEW_OPTIONS));
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        OlapUnit unit = (OlapUnit)res;
        unit.setMdxQuery(this.getMdxQuery());
        unit.setOlapClientConnection(importHandler.handleReference(this.getOlapClientConnection()));
        unit.setOlapViewOptions(this.constructViewOptions(importHandler));
    }

    protected Object constructViewOptions(ResourceImportHandler importHandler) {
        Object options;
        if (this.olapViewOptionsDataFile == null) {
            options = null;
        } else {
            byte[] viewOptionsData = importHandler.handleData(this, this.olapViewOptionsDataFile, DATA_PROVIDER_VIEW_OPTIONS);
            XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(viewOptionsData));
            options = decoder.readObject();
            decoder.close();
        }
        return options;
    }

    public String getMdxQuery() {
        return this.mdxQuery;
    }

    public void setMdxQuery(String mdxQuery) {
        this.mdxQuery = mdxQuery;
    }

    public ResourceReferenceBean getOlapClientConnection() {
        return this.olapClientConnection;
    }

    public void setOlapClientConnection(ResourceReferenceBean olapClientConnection) {
        this.olapClientConnection = olapClientConnection;
    }

    public String getOlapViewOptionsDataFile() {
        return this.olapViewOptionsDataFile;
    }

    public void setOlapViewOptionsDataFile(String olapViewOptionsDataFile) {
        this.olapViewOptionsDataFile = olapViewOptionsDataFile;
    }
}

