/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;

public class XmlaConnectionBean
extends ResourceBean {
    private String uri;
    private String dataSource;
    private String catalog;
    private String username;
    private String password;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
        XMLAConnection xmla = (XMLAConnection)res;
        this.setUri(xmla.getURI());
        this.setDataSource(xmla.getDataSource());
        this.setCatalog(xmla.getCatalog());
        this.setUsername(xmla.getUsername());
        this.setPassword("ENC<" + importExportCipher.encode(xmla.getPassword()) + ">");
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        XMLAConnection xmla = (XMLAConnection)res;
        xmla.setURI(this.getUri());
        xmla.setDataSource(this.getDataSource());
        xmla.setCatalog(this.getCatalog());
        xmla.setUsername(this.getUsername());
        String pwd = this.getPassword();
        xmla.setPassword(pwd != null && pwd.startsWith("ENC<") && pwd.endsWith(">") ? importExportCipher.decode(pwd.replaceFirst("ENC<", "").replaceAll(">$", "")) : pwd);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

