/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling;

import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImporter;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.HolidayCalendarBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.quartz.Calendar;
import org.quartz.impl.calendar.HolidayCalendar;

public class CalendarsImporter
extends BaseImporterModule {
    private static final Log log = LogFactory.getLog(ResourceImporter.class);
    protected SchedulingModuleConfiguration configuration;
    private String updateArg;
    protected boolean updateExisting;

    @Override
    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.updateExisting = this.hasParameter(this.getUpdateArg());
    }

    @Override
    public List<String> process() {
        Iterator i = this.indexElement.elementIterator(this.configuration.getIndexCalendarElement());
        while (i.hasNext()) {
            Element calendarElement = (Element)i.next();
            String name = calendarElement.getText();
            this.processCalendar(name);
        }
        return null;
    }

    protected void processCalendar(String name) {
        if (!this.isCalendarExist(name) || this.updateExisting) {
            HolidayCalendarBean bean = this.deserializeCalendar(name);
            HolidayCalendar calendar = new HolidayCalendar();
            bean.copyTo(calendar);
            this.configuration.getReportJobsScheduler().addCalendar(bean.getName(), (Calendar)calendar, true, true);
        }
    }

    protected boolean isCalendarExist(String name) {
        Calendar calendar = this.configuration.getReportJobsScheduler().getCalendar(name);
        return calendar != null;
    }

    protected HolidayCalendarBean deserializeCalendar(String name) {
        String path = this.configuration.getCalendarsDir();
        String filename = this.getCalendarFilename(name);
        return (HolidayCalendarBean)this.deserialize(path, filename, this.configuration.getSerializer());
    }

    protected String getCalendarFilename(String name) {
        return PathUtils.preparePathComponent(name) + ".xml";
    }

    public SchedulingModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SchedulingModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getUpdateArg() {
        return this.updateArg;
    }

    public void setUpdateArg(String updateArg) {
        this.updateArg = updateArg;
    }
}

