/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling.beans;

import java.util.Date;
import java.util.TimeZone;
import org.quartz.impl.calendar.HolidayCalendar;

public class HolidayCalendarBean {
    private String name;
    private String description;
    private String timezone;
    private Date[] excludedDates;

    public void copyFrom(HolidayCalendar src) {
        this.setDescription(src.getDescription());
        if (src.getTimeZone() != null) {
            this.setTimezone(src.getTimeZone().getID());
        }
        int size = src.getExcludedDates().size();
        this.excludedDates = src.getExcludedDates().toArray(new Date[size]);
    }

    public void copyTo(HolidayCalendar dest) {
        dest.setDescription(this.getDescription());
        if (this.getTimezone() != null) {
            dest.setTimeZone(TimeZone.getTimeZone(this.getTimezone()));
        }
        for (Date date : this.getExcludedDates()) {
            dest.addExcludedDate(date);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date[] getExcludedDates() {
        return this.excludedDates;
    }

    public void setExcludedDates(Date[] excludedDates) {
        this.excludedDates = excludedDates;
    }
}

