/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticFilesCacheControlFilter
implements Filter {
    public static final String URL_ENDS_WITH = "urlEndsWith";
    public static final String URL_STARTS_WITH = "urlStartsWith";
    public static final String EXPIRES_AFTER_ACCESS_IN_SECS = "expiresAfterAccessInSecs";
    public static final String DATE_FORMAT_PATTERN = "EEE, d MMM yyyy HH:mm:ss z";
    private static final Log log = LogFactory.getLog(StaticFilesCacheControlFilter.class);
    private Set<String> urlSuffixes = new HashSet<String>();
    private Set<String> urlPrefixes = new HashSet<String>();
    private int expiresInSecs = 0;
    private static final ThreadLocal<Map<Locale, DateFormat>> lastDateFormat = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration paramNames = filterConfig.getInitParameterNames();
        while (paramNames != null && paramNames.hasMoreElements()) {
            int i;
            String[] types;
            String value;
            String paramName = (String)paramNames.nextElement();
            if (URL_ENDS_WITH.equals(paramName)) {
                value = filterConfig.getInitParameter(paramName);
                if (value == null || value.length() <= 0) continue;
                types = value.split(" ");
                for (i = 0; i < types.length; ++i) {
                    if (types[i].length() <= 0) continue;
                    this.urlSuffixes.add(types[i].toLowerCase());
                    log.debug((Object)("URL suffix added : " + types[i]));
                }
                continue;
            }
            if (URL_STARTS_WITH.equals(paramName)) {
                value = filterConfig.getInitParameter(paramName);
                if (value == null || value.length() <= 0) continue;
                types = value.split(" ");
                for (i = 0; i < types.length; ++i) {
                    if (types[i].length() <= 0) continue;
                    this.urlPrefixes.add(types[i].toLowerCase());
                    log.debug((Object)("URL prefix added : " + types[i]));
                }
                continue;
            }
            if (EXPIRES_AFTER_ACCESS_IN_SECS.equals(paramName)) {
                value = filterConfig.getInitParameter(paramName);
                try {
                    this.expiresInSecs = Integer.parseInt(value);
                    log.debug((Object)("Expires in seconds set : " + this.expiresInSecs));
                }
                catch (Exception ex) {
                    log.error((Object)"expiresAfterAccessInSecs should be a non-negative integer", (Throwable)ex);
                }
                continue;
            }
            log.warn((Object)("Unknown parameter, ignoring : " + paramName));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String path = httpServletRequest.getServletPath();
            if (path != null) {
                String resourcePatch = httpServletRequest.getPathInfo() == null ? path : path.concat(httpServletRequest.getPathInfo());
                boolean set = false;
                for (String suffix : this.urlSuffixes) {
                    if (!path.toLowerCase().endsWith(suffix)) continue;
                    log.debug((Object)("Setting headers for " + path));
                    this.setHeaders(httpServletRequest, httpServletResponse);
                    set = true;
                    break;
                }
                if (!set) {
                    for (String prefix : this.urlPrefixes) {
                        if (!resourcePatch.toLowerCase().startsWith(prefix)) continue;
                        log.debug((Object)("Setting headers for " + resourcePatch));
                        this.setHeaders(httpServletRequest, httpServletResponse);
                        break;
                    }
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private void setHeaders(HttpServletRequest request, HttpServletResponse response) {
        try {
            DateFormat df = this.getFormat(request.getLocale());
            response.setHeader("Cache-Control", "max-age=" + this.expiresInSecs + ", public");
            response.setHeader("Pragma", "");
            response.setHeader("Expires", df.format(new Date(new Date().getTime() + (long)(this.expiresInSecs * 1000))));
        }
        catch (Exception ex) {
            log.warn((Object)"Cannot set cache headers", (Throwable)ex);
        }
    }

    private DateFormat getFormat(Locale locale) {
        DateFormat dateFormat;
        Map<Locale, DateFormat> map = lastDateFormat.get();
        if (map == null) {
            map = new HashMap<Locale, DateFormat>();
            lastDateFormat.set(map);
        }
        if ((dateFormat = map.get(locale)) == null) {
            dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, locale);
            map.put(locale, dateFormat);
        }
        return dateFormat;
    }
}

