/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.CsvExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import org.springframework.webflow.execution.RequestContext;

public class ReportCsvExporter
extends AbstractReportExporter {
    private static final String DIALOG_NAME = "csvExportParams";
    private CsvExportParametersBean exportParameters;
    private String contentType = "application/octet-stream";
    private String contentDisposition = "attachment";

    @Override
    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException {
        JRCsvExporter exporter = new JRCsvExporter(this.getJasperReportsContext());
        exporter.setParameters(baseParameters);
        CsvExportParametersBean exportParams = (CsvExportParametersBean)this.getExportParameters(context);
        if (exportParams.isOverrideReportHints()) {
            exporter.setParameter(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS, (Object)Boolean.TRUE);
        }
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)exportParams.getFieldDelimiter());
        exporter.exportReport();
    }

    @Override
    protected String getContentType(RequestContext context) {
        return this.contentType;
    }

    @Override
    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", this.contentDisposition + "; filename=\"" + this.getFilename(context) + "\"");
    }

    @Override
    protected String getDownloadFileExtension() {
        return "csv";
    }

    public CsvExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    public void setExportParameters(CsvExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }

    @Override
    public ExportParameters getExportParameters(RequestContext context) {
        return context.getFlowScope().get(DIALOG_NAME) == null ? this.exportParameters : (ExportParameters)context.getFlowScope().get(DIALOG_NAME);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }
}

