/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSShowOnlyErrorMessage;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.war.action.JSController;
import com.jaspersoft.jasperserver.war.action.ReportExecutionAttributes;
import com.jaspersoft.jasperserver.war.action.ViewReportAction;
import com.jaspersoft.jasperserver.war.action.WebflowReportContext;
import com.jaspersoft.jasperserver.war.action.WebflowReportContextAccessor;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFactoryFlowFactory;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JsonExporter;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.actions.MultiAction;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.RequirejsModuleMapping;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class ReportExecutionController
extends MultiActionController {
    private static final Log log = LogFactory.getLog(ViewReportAction.class);
    public static final String REPORT_EXECUTION_PREFIX = "flowReportExecution";
    public static final String REPORT_EXECUTION_ID_PREFIX = "flowReportExecutionId";
    public static final String REPORT_CONTEXT_HTML_PRINT_ID = "htmlReportJRPrintId";
    public static final String REPORT_CONTEXT_HTML_FLOW_KEY = "htmlReportFlowExecutionKey";
    private static final View NULL_VIEW = new View(){

        public String getContentType() {
            return null;
        }

        public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }
    };
    private EngineService engineService;
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private DataCacheProvider dataCacheProvider;
    private JasperReportsContext jasperReportsContext;
    private WebflowReportContextAccessor reportContextAccessor;
    private HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory;
    private final View REPORT_COMPONENTS_VIEW = new View(){

        public String getContentType() {
            return "application/json; charset=UTF-8";
        }

        public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            try {
                JasperPrintAccessor jasperPrintAccessor;
                String htmlType = JRPropertiesUtil.getInstance((JasperReportsContext)ReportExecutionController.this.jasperReportsContext).getProperty("com.jaspersoft.jasperreports.export.html.type");
                if (!"html2".equals(htmlType)) {
                    response.setContentType(this.getContentType());
                    PrintWriter writer = response.getWriter();
                    writer.println("{}");
                    return;
                }
                String reportName = ReportExecutionController.this.getReportName(request);
                ReportUnitResult reportResult = ReportExecutionController.this.getReportResult(request, reportName);
                JasperPrintAccessor jasperPrintAccessor2 = jasperPrintAccessor = reportResult == null ? null : reportResult.getJasperPrintAccessor();
                if (jasperPrintAccessor == null) {
                    return;
                }
                ReportExecutionStatus reportStatus = jasperPrintAccessor.getReportStatus();
                if (reportStatus.getStatus() == ReportExecutionStatus.Status.ERROR) {
                    throw new JRRuntimeException("Error occurred during report generation", reportStatus.getError());
                }
                boolean hasPages = jasperPrintAccessor.pageStatus(0, null).pageExists();
                JsonExporter exporter = new JsonExporter(ReportExecutionController.this.jasperReportsContext);
                ReportPageStatus pageStatus = null;
                if (hasPages) {
                    String reportPage = request.getParameter("pageIndex");
                    int pageIdx = reportPage == null ? 0 : Integer.parseInt(reportPage);
                    pageStatus = jasperPrintAccessor.pageStatus(pageIdx, null);
                    if (!pageStatus.pageExists()) {
                        throw new JRRuntimeException("Page " + pageIdx + " not found in report");
                    }
                    exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIdx);
                }
                response.setContentType(this.getContentType());
                ReportContext reportContext = reportResult.getReportContext();
                this.prepareExport(request, reportName, reportContext);
                exporter.setReportContext(reportContext);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrintAccessor.getJasperPrint());
                exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)response.getWriter());
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, null);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, null);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, null);
                JRHyperlinkProducerFactory hyperlinkFactory = ReportExecutionController.this.getHyperlinkProducerFactory().getHyperlinkProducerFactory(request, response);
                exporter.setParameter(JRHtmlExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)hyperlinkFactory);
                exporter.exportReport();
                reportContext.setParameterValue("net.sf.jasperreports.engine.export.clear.json.cache", (Object)Boolean.FALSE);
            }
            catch (JRRuntimeException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                response.setContentType(this.getContentType());
                response.setStatus(500);
                PrintWriter pw = response.getWriter();
                HashMap result = new HashMap();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("msg", e.getMessage());
                if (e.getCause() != null) {
                    map.put("devmsg", e.getCause().getMessage());
                } else {
                    map.put("devmsg", e.getMessage());
                }
                result.put("result", map);
                pw.write(JacksonUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getJsonString(result));
            }
        }

        protected void prepareExport(HttpServletRequest request, String reportName, ReportContext reportContext) {
            String htmlReportName;
            String flowExecutionKey = null;
            if (reportContext != null && (htmlReportName = (String)reportContext.getParameterValue(ReportExecutionController.REPORT_CONTEXT_HTML_PRINT_ID)) != null && htmlReportName.equals(reportName)) {
                flowExecutionKey = (String)reportContext.getParameterValue(ReportExecutionController.REPORT_CONTEXT_HTML_FLOW_KEY);
            }
            request.setAttribute("flowExecutionKey", flowExecutionKey);
        }
    };

    public ModelAndView viewReportCancel(HttpServletRequest req, HttpServletResponse res) {
        String flowExecutionKey = req.getParameter("_flowExecutionKey");
        String sessionName = REPORT_EXECUTION_PREFIX + flowExecutionKey;
        ReportExecutionAttributes execution = (ReportExecutionAttributes)req.getSession().getAttribute(sessionName);
        if (execution == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No report execution to cancel");
            }
        } else {
            boolean canceled = this.engineService.cancelExecution(execution.getRequestId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Report execution " + execution.getRequestId() + " cancel status: " + canceled));
            }
        }
        return new ModelAndView(NULL_VIEW);
    }

    public ModelAndView viewReportAsyncCancel(HttpServletRequest req, HttpServletResponse res) throws Exception {
        ReportUnitResult result = this.getReportResult(req);
        String requestId = result == null ? null : result.getRequestId();
        LinkedHashMap<String, Object> actionResult = new LinkedHashMap<String, Object>();
        if (requestId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No async report execution to cancel");
            }
        } else {
            boolean canceled = this.engineService.cancelExecution(requestId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Report execution " + requestId + " cancel status: " + canceled));
            }
            JasperPrintAccessor resultPrintAccessor = result.getJasperPrintAccessor();
            try {
                resultPrintAccessor.getFinalJasperPrint();
            }
            catch (JRRuntimeException e) {
                // empty catch block
            }
            this.putReportStatusResult(res, result, actionResult);
        }
        return new ModelAndView("json:result", Collections.singletonMap("result", actionResult));
    }

    protected String getReportName(HttpServletRequest req) {
        return req.getParameter("jasperPrintName");
    }

    protected ReportUnitResult getReportResult(HttpServletRequest req, String jasperPrintName) {
        if (jasperPrintName != null && req.getAttribute("jasperPrintName") == null) {
            req.setAttribute("jasperPrintName", (Object)jasperPrintName);
        }
        ReportUnitResult result = (ReportUnitResult)this.getJasperPrintAccessor().getObject(req, jasperPrintName);
        return result;
    }

    protected ReportUnitResult getReportResult(HttpServletRequest req) {
        String jasperPrintName = this.getReportName(req);
        return this.getReportResult(req, jasperPrintName);
    }

    public ModelAndView viewReportPageUpdateCheck(HttpServletRequest req, HttpServletResponse res) throws Exception {
        Long pageTimestamp;
        JasperPrintAccessor printAccessor;
        ReportUnitResult reportResult = this.getReportResult(req);
        JasperPrintAccessor jasperPrintAccessor = printAccessor = reportResult == null ? null : reportResult.getJasperPrintAccessor();
        if (printAccessor == null) {
            return null;
        }
        String pageIdxParam = req.getParameter("pageIndex");
        Integer pageIndex = pageIdxParam == null ? null : Integer.valueOf(pageIdxParam);
        String pageTimestampParam = req.getParameter("pageTimestamp");
        Long l = pageTimestamp = pageTimestampParam == null ? null : Long.valueOf(pageTimestampParam);
        if (log.isDebugEnabled()) {
            log.debug((Object)("report page update check for " + reportResult.getRequestId() + ", pageIndex: " + pageIndex + ", pageTimestamp: " + pageTimestamp));
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.putReportStatusResult(res, reportResult, result);
        ReportExecutionStatus reportStatus = printAccessor.getReportStatus();
        ReportPageStatus pageStatus = null;
        if (pageIndex != null && pageTimestamp != null) {
            pageStatus = printAccessor.pageStatus(pageIndex.intValue(), pageTimestamp);
            boolean modified = pageStatus.hasModified();
            result.put("pageModified", modified);
            if (log.isDebugEnabled()) {
                log.debug((Object)("page modified " + modified));
            }
        }
        return new ModelAndView("json:result", Collections.singletonMap("result", result));
    }

    public ModelAndView runReportAction(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String reportContextId = req.getParameter("jr_ctxid");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (reportContextId != null && req.getParameterMap().containsKey("jr_action")) {
            WebflowReportContext reportContext = this.reportContextAccessor.getContextById(req, reportContextId);
            Action action = this.getAction(req, reportContext, this.jasperReportsContext);
            JSController controller = new JSController(this.jasperReportsContext);
            try {
                controller.runAction(reportContext, action);
                result.put("contextid", reportContextId);
            }
            catch (JRInteractiveException e) {
                res.setStatus(500);
                result = new LinkedHashMap();
                result.put("msg", "The server encountered an error!");
                result.put("devmsg", e.getMessage());
            }
        } else {
            res.setStatus(400);
            result.put("msg", "Wrong parameters!");
        }
        return new ModelAndView("json:result", Collections.singletonMap("result", result));
    }

    private Action getAction(HttpServletRequest request, ReportContext webReportContext, JasperReportsContext jrContext) {
        String jsonData = request.getParameter("jr_action");
        Action result = null;
        List actions = JacksonUtil.getInstance((JasperReportsContext)jrContext).loadAsList(jsonData, AbstractAction.class);
        if (actions != null) {
            if (actions.size() == 1) {
                result = (Action)actions.get(0);
            } else if (actions.size() > 1) {
                result = new MultiAction(actions);
            }
            ((AbstractAction)result).init(jrContext, webReportContext);
        }
        return result;
    }

    public ModelAndView getReportComponents(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView(this.REPORT_COMPONENTS_VIEW);
    }

    public ModelAndView getRequirejsConfig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil webUtil = WebUtil.getInstance((JasperReportsContext)this.getJasperReportsContext());
        List requirejsMappings = this.getJasperReportsContext().getExtensions(RequirejsModuleMapping.class);
        LinkedHashMap<String, String> modulePaths = new LinkedHashMap<String, String>();
        for (RequirejsModuleMapping requirejsMapping : requirejsMappings) {
            if (modulePaths.containsKey(requirejsMapping.getName())) continue;
            String modulePath = requirejsMapping.getPath();
            if (requirejsMapping.isClasspathResource()) {
                modulePath = request.getContextPath() + webUtil.getResourcesBasePath() + modulePath;
            }
            modulePaths.put(requirejsMapping.getName(), modulePath);
        }
        request.setAttribute("contextPath", (Object)request.getContextPath());
        request.setAttribute("modulePaths", modulePaths);
        return new ModelAndView("modules/requirejs.config");
    }

    protected void putReportStatusResult(HttpServletResponse res, ReportUnitResult reportResult, LinkedHashMap<String, Object> result) throws Exception {
        String status;
        JasperPrintAccessor printAccessor = reportResult.getJasperPrintAccessor();
        ReportExecutionStatus reportStatus = printAccessor.getReportStatus();
        result.put("lastPartialPageIndex", reportStatus.getCurrentPageCount() - 1);
        switch (reportStatus.getStatus()) {
            case FINISHED: {
                status = "finished";
                Integer totalPageCount = reportStatus.getTotalPageCount();
                result.put("lastPageIndex", totalPageCount - 1);
                ReportContext reportContext = reportResult.getReportContext();
                DataCacheProvider.SnapshotSaveStatus snapshotSaveStatus = this.dataCacheProvider.getSnapshotSaveStatus(reportContext);
                if (snapshotSaveStatus != null) {
                    result.put("snapshotSaveStatus", snapshotSaveStatus.toString());
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("report finished " + totalPageCount + " pages; snapshot status " + snapshotSaveStatus));
                break;
            }
            case ERROR: {
                status = "error";
                this.handleReportUpdateError(res, reportStatus);
                break;
            }
            case CANCELED: {
                status = "canceled";
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"report canceled");
                break;
            }
            default: {
                status = "running";
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"report running");
            }
        }
        result.put("status", status);
    }

    protected void handleReportUpdateError(HttpServletResponse res, ReportExecutionStatus reportStatus) throws Exception {
        Throwable error = reportStatus.getError();
        if (log.isDebugEnabled()) {
            log.debug((Object)("report error " + error));
        }
        res.setHeader("reportError", "true");
        res.setHeader("lastPartialPageIndex", Integer.toString(reportStatus.getCurrentPageCount() - 1));
        if (error instanceof Exception) {
            int indexIO = ExceptionUtils.indexOfThrowable((Throwable)error, IOException.class);
            if (indexIO != -1) {
                Exception sourceException = (Exception)ExceptionUtils.getThrowableList((Throwable)error).get(indexIO);
                throw new JSShowOnlyErrorMessage(sourceException.getMessage());
            }
            throw (Exception)error;
        }
        throw new JSException("jsexception.view.report.error", error);
    }

    public EngineService getEngineService() {
        return this.engineService;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    public DataCacheProvider getDataCacheProvider() {
        return this.dataCacheProvider;
    }

    public void setDataCacheProvider(DataCacheProvider dataCacheProvider) {
        this.dataCacheProvider = dataCacheProvider;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public WebflowReportContextAccessor getReportContextAccessor() {
        return this.reportContextAccessor;
    }

    public void setReportContextAccessor(WebflowReportContextAccessor reportContextAccessor) {
        this.reportContextAccessor = reportContextAccessor;
    }

    public HyperlinkProducerFactoryFlowFactory getHyperlinkProducerFactory() {
        return this.hyperlinkProducerFactory;
    }

    public void setHyperlinkProducerFactory(HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory) {
        this.hyperlinkProducerFactory = hyperlinkProducerFactory;
    }
}

