/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlValueInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlValuesInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlsInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlState;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.ReportInputControl;
import com.jaspersoft.jasperserver.war.cascade.CachedEngineService;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.ControlLogic;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationError;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.InputControlsValidationException;
import com.jaspersoft.jasperserver.war.cascade.cache.ControlLogicCacheManager;
import com.jaspersoft.jasperserver.war.cascade.handlers.InputControlHandler;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.InputControlValueClassResolver;
import com.jaspersoft.jasperserver.war.cascade.token.FilterResolver;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GenericInputControlLogic<T extends InputControlsContainer>
implements ControlLogic<T> {
    public static final String INPUT_CONTROL_CONFIGURATION_KEY_HANDLER = "handler";
    public static final String INPUT_CONTROL_CONFIGURATION_KEY_UI_TYPE = "uiType";
    @Resource
    protected ControlLogicCacheManager controlLogicCacheManager;
    @Resource
    protected CachedRepositoryService cachedRepositoryService;
    @Resource
    protected CachedEngineService cachedEngineService;
    @Resource
    protected Map<String, Map<String, Object>> inputControlTypeConfiguration;
    @Resource
    protected FilterResolver filterResolver;

    @Override
    public final List<ReportInputControl> getInputControlsStructure(T container, Set<String> inputControlIds) throws CascadeResourceNotFoundException {
        ReportInputControlsInformation reportInputControlsInformation = this.getReportInputControlsInformation(container);
        List<InputControl> allInputControls = this.getAllInputControls(container);
        List<InputControl> localizedInputControls = this.localizeInputControls(allInputControls, reportInputControlsInformation);
        ResourceReference dataSource = this.getMainDataSource(container);
        return this.getInputControlsStructure(localizedInputControls, inputControlIds, dataSource);
    }

    protected List<InputControl> localizeInputControls(List<InputControl> inputControls, ReportInputControlsInformation infos) {
        for (InputControl inputControl : inputControls) {
            ReportInputControlInformation controlInfo = infos.getInputControlInformation(inputControl.getName());
            if (controlInfo == null) continue;
            inputControl.setLabel(controlInfo.getPromptLabel());
            ReportInputControlValuesInformation controlValueInfos = controlInfo.getReportInputControlValuesInformation();
            if (controlValueInfos == null) continue;
            ListOfValuesImpl localizedListOfValues = new ListOfValuesImpl();
            Set controlValuesNames = controlValueInfos.getControlValuesNames();
            for (String controlValueName : controlValuesNames) {
                ReportInputControlValueInformation inputControlValueInformation = controlValueInfos.getInputControlValueInformation(controlValueName);
                ListOfValuesItemImpl valuesItem = new ListOfValuesItemImpl();
                valuesItem.setLabel(inputControlValueInformation.getPromptLabel());
                valuesItem.setValue(inputControlValueInformation.getDefaultValue());
                localizedListOfValues.addValue((ListOfValuesItem)valuesItem);
            }
            inputControl.setListOfValues((ListOfValues)localizedListOfValues);
        }
        return inputControls;
    }

    protected List<ReportInputControl> getInputControlsStructure(List<InputControl> inputControls, Set<String> inputControlIds, ResourceReference dataSource) throws CascadeResourceNotFoundException {
        ArrayList<ReportInputControl> result = new ArrayList<ReportInputControl>();
        HashMap<String, ReportInputControl> controlsMap = new HashMap<String, ReportInputControl>();
        for (InputControl inputControl : inputControls) {
            if (inputControlIds != null && !inputControlIds.isEmpty() && !inputControlIds.contains(inputControl.getName())) continue;
            Map<String, Object> typeConfiguration = this.inputControlTypeConfiguration.get(String.valueOf(inputControl.getType()));
            InputControlHandler handler = this.getHandlerForInputControl(inputControl, typeConfiguration);
            String uiType = (String)typeConfiguration.get(INPUT_CONTROL_CONFIGURATION_KEY_UI_TYPE);
            ReportInputControl control = handler.buildReportInputControl(inputControl, uiType, dataSource);
            result.add(control);
            controlsMap.put(control.getId(), control);
        }
        this.resolveDependencies(controlsMap);
        return result;
    }

    private void resolveDependencies(Map<String, ReportInputControl> controlsMap) {
        for (ReportInputControl control : controlsMap.values()) {
            List currentDependencies = control.getMasterDependencies();
            ArrayList<String> masterDependenciesToRemove = new ArrayList<String>();
            if (currentDependencies.isEmpty()) continue;
            for (String parameter : currentDependencies) {
                ReportInputControl masterControl = controlsMap.get(parameter);
                if (masterControl != null) {
                    masterControl.getSlaveDependencies().add(control.getId());
                    continue;
                }
                masterDependenciesToRemove.add(parameter);
            }
            if (masterDependenciesToRemove.isEmpty()) continue;
            currentDependencies.removeAll(masterDependenciesToRemove);
        }
    }

    protected ReportInputControlsInformation getReportInputControlsInformation(T container) throws CascadeResourceNotFoundException {
        Map<String, Object> initialParameters = this.getDefaultValues(container);
        ExecutionContext context = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)JasperServerUtil.getExecutionContext());
        return this.cachedEngineService.getReportInputControlsInformation(context, (InputControlsContainer)container, initialParameters);
    }

    protected Map<String, Object> getDefaultValues(T container) throws CascadeResourceNotFoundException {
        return new HashMap<String, Object>();
    }

    protected ResourceReference getMainDataSource(T container) throws CascadeResourceNotFoundException {
        return container.getDataSource();
    }

    protected List<InputControl> getAllInputControls(T container) throws CascadeResourceNotFoundException {
        return this.cachedEngineService.getInputControls((InputControlsContainer)container);
    }

    protected List<InputControlState> getValuesForInputControls(T container, List<InputControl> controls, ResourceReference dataSource, Map<String, Object> executionParameters, Map<String, Class<?>> parameterTypes, ReportInputControlsInformation infos) throws CascadeResourceNotFoundException {
        ArrayList<InputControlState> values = new ArrayList<InputControlState>();
        for (InputControl inputControl : controls) {
            ReportInputControlInformation info;
            InputControlHandler icHandler = this.getHandlerForInputControl(inputControl);
            InputControlState value = icHandler.getState(inputControl, dataSource, executionParameters, parameterTypes, info = infos.getInputControlInformation(inputControl.getName()));
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    protected DataType getDataType(InputControl inputControl) throws CascadeResourceNotFoundException {
        return inputControl != null && inputControl.getDataType() != null ? this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()) : null;
    }

    @Override
    public final List<InputControlState> getValuesForInputControlsFromRawData(T container, Set<String> inputControlIds, Map<String, String[]> requestParameters) throws CascadeResourceNotFoundException {
        List<InputControl> allControls = this.getAllInputControls(container);
        ResourceReference dataSource = this.getMainDataSource(container);
        this.resolveCascadingOrder(allControls, dataSource);
        ReportInputControlsInformation infos = this.getReportInputControlsInformation(container);
        ValidationErrorsImpl validationErrors = new ValidationErrorsImpl();
        Map<String, Object> typedParameters = this.getTypedParameters(allControls, requestParameters, infos, (ValidationErrors)validationErrors);
        HashMap parameterTypes = new HashMap(allControls.size());
        for (InputControl inputControl : allControls) {
            DataType dataType = this.getDataType(inputControl);
            parameterTypes.put(inputControl.getName(), InputControlValueClassResolver.getValueClass(dataType, infos.getInputControlInformation(inputControl.getName()), false));
        }
        List<InputControlState> states = this.getValuesForInputControls(container, this.filterSelectedInputControls(inputControlIds, allControls), dataSource, typedParameters, parameterTypes, infos);
        this.addValidationErrorsToInputControlStates(states, (ValidationErrors)validationErrors, allControls);
        return states;
    }

    private void addValidationErrorsToInputControlStates(List<InputControlState> states, ValidationErrors validationErrors, List<InputControl> allControls) {
        if (!validationErrors.getErrors().isEmpty()) {
            block0: for (Object errorObject : validationErrors.getErrors()) {
                InputControlValidationError error = (InputControlValidationError)((Object)errorObject);
                boolean stateFound = false;
                for (InputControlState state : states) {
                    if (!state.getUri().equals(error.getInputControlUri())) continue;
                    state.setError(error.getDefaultMessage());
                    state.setValue(error.getInvalidValue());
                    stateFound = true;
                    break;
                }
                if (stateFound) continue;
                for (InputControl control : allControls) {
                    if (!control.getURIString().equals(error.getInputControlUri())) continue;
                    InputControlState state = new InputControlState();
                    state.setUri(control.getURIString());
                    state.setId(control.getName());
                    state.setError(error.getDefaultMessage());
                    state.setValue(error.getInvalidValue());
                    states.add(state);
                    continue block0;
                }
            }
        }
    }

    protected List<InputControl> filterSelectedInputControls(Set<String> inputControlIds, List<InputControl> allControls) {
        ArrayList<InputControl> selectedControls = new ArrayList<InputControl>();
        if (inputControlIds != null && !inputControlIds.isEmpty()) {
            for (InputControl control : allControls) {
                if (!inputControlIds.contains(control.getName())) continue;
                selectedControls.add(control);
            }
        } else {
            selectedControls.addAll(allControls);
        }
        return selectedControls;
    }

    protected void resolveCascadingOrder(List<InputControl> inputControls, ResourceReference dataSource) throws CascadeResourceNotFoundException {
        LinkedHashMap<String, InputControl> inputControlIndexMap = new LinkedHashMap<String, InputControl>();
        LinkedHashMap<String, Set<String>> masterDependencies = new LinkedHashMap<String, Set<String>>();
        for (InputControl inputControl : inputControls) {
            inputControlIndexMap.put(inputControl.getName(), inputControl);
        }
        for (Map.Entry entry : inputControlIndexMap.entrySet()) {
            masterDependencies.put((String)entry.getKey(), this.getCheckedMastedDependenciesForInputControl((InputControl)entry.getValue(), inputControlIndexMap.keySet(), dataSource));
        }
        LinkedHashSet<String> orderedInputControlNames = this.filterResolver.resolveCascadingOrder(masterDependencies);
        ArrayList arrayList = new ArrayList();
        for (String inputControlName : orderedInputControlNames) {
            arrayList.add(inputControlIndexMap.get(inputControlName));
        }
        inputControls.clear();
        inputControls.addAll(arrayList);
    }

    private Set<String> getCheckedMastedDependenciesForInputControl(InputControl inputControl, Set<String> allInputControlNames, ResourceReference dataSource) throws CascadeResourceNotFoundException {
        InputControlHandler icHandler = this.getHandlerForInputControl(inputControl);
        Set<String> rawMasterDependencies = icHandler.getMasterDependencies(inputControl, dataSource);
        HashSet<String> checkedMasterDependencies = new HashSet<String>();
        if (rawMasterDependencies != null && !rawMasterDependencies.isEmpty()) {
            for (String masterId : rawMasterDependencies) {
                if (!allInputControlNames.contains(masterId)) continue;
                checkedMasterDependencies.add(masterId);
            }
        }
        return checkedMasterDependencies;
    }

    @Override
    public final Map<String, Object> getTypedParameters(T container, Map<String, String[]> requestParameters, boolean skipValidation) throws CascadeResourceNotFoundException, InputControlsValidationException {
        List<InputControl> controls = this.getAllInputControls(container);
        ReportInputControlsInformation infos = this.getReportInputControlsInformation(container);
        ValidationErrorsImpl validationErrors = new ValidationErrorsImpl();
        Map<String, Object> typedParameters = this.getTypedParameters(controls, requestParameters, infos, (ValidationErrors)validationErrors);
        for (InputControl control : controls) {
            if (typedParameters.containsKey(control.getName())) continue;
            this.restoreAbsentParameter(typedParameters, control.getName());
        }
        if (!validationErrors.getErrors().isEmpty() && !skipValidation) {
            throw new InputControlsValidationException((ValidationErrors)validationErrors);
        }
        return typedParameters;
    }

    protected void restoreAbsentParameter(Map<String, Object> typedParameters, String absentControlName) {
        typedParameters.put(absentControlName, null);
    }

    @Override
    public Map<String, String[]> formatTypedParameters(T container, Map<String, Object> typedParameters) throws CascadeResourceNotFoundException {
        List<InputControl> controls = this.getAllInputControls(container);
        ReportInputControlsInformation infos = this.getReportInputControlsInformation(container);
        HashMap<String, String[]> formattedValues = new HashMap<String, String[]>(controls.size());
        for (InputControl control : controls) {
            InputControlHandler icHandler = this.getHandlerForInputControl(control);
            String controlName = control.getName();
            formattedValues.put(controlName, icHandler.formatValue(typedParameters.get(controlName), control, infos.getInputControlInformation(controlName)));
        }
        return formattedValues;
    }

    protected Map<String, Object> getTypedParameters(List<InputControl> inputControls, Map<String, String[]> requestParameters, ReportInputControlsInformation infos, ValidationErrors validationErrors) throws CascadeResourceNotFoundException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (inputControls != null) {
            if (requestParameters == null) {
                requestParameters = Collections.emptyMap();
            }
            for (InputControl inputControl : inputControls) {
                String inputControlName = inputControl.getName();
                String[] valuesFromRequest = (String[])requestParameters.get(inputControlName);
                InputControlHandler icHandler = this.getHandlerForInputControl(inputControl);
                if (icHandler.isNothingSelected(valuesFromRequest)) {
                    icHandler.applyNothingSelected(inputControlName, result);
                    continue;
                }
                try {
                    result.put(inputControlName, icHandler.convertParameterValueFromRawData(valuesFromRequest, inputControl, infos.getInputControlInformation(inputControlName)));
                }
                catch (InputControlValidationException e) {
                    InputControlValidationError error = e.getValidationError();
                    if (error.getInvalidValue() != null) {
                        error.setInputControlUri(inputControl.getURIString());
                        validationErrors.add((ValidationError)error);
                    }
                    icHandler.applyNothingSelected(inputControlName, result);
                }
            }
        }
        return result;
    }

    protected InputControlHandler getHandlerForInputControl(InputControl inputControl) {
        Map<String, Object> typeConfiguration = this.inputControlTypeConfiguration.get(String.valueOf(inputControl.getType()));
        return this.getHandlerForInputControl(inputControl, typeConfiguration);
    }

    protected InputControlHandler getHandlerForInputControl(InputControl inputControl, Map<String, Object> typeConfiguration) {
        InputControlHandler result = null;
        if (inputControl != null) {
            if (typeConfiguration == null) {
                throw new IllegalArgumentException("Input control type '" + inputControl.getType() + "' isn't configured");
            }
            if (typeConfiguration.get(INPUT_CONTROL_CONFIGURATION_KEY_HANDLER) == null) {
                throw new IllegalStateException("Handler for input control type '" + inputControl.getType() + "' isn't configured");
            }
            if (!(typeConfiguration.get(INPUT_CONTROL_CONFIGURATION_KEY_HANDLER) instanceof InputControlHandler)) {
                throw new IllegalStateException("Handler for input control type '" + inputControl.getType() + "' must be of type " + InputControlHandler.class.getName());
            }
            result = (InputControlHandler)typeConfiguration.get(INPUT_CONTROL_CONFIGURATION_KEY_HANDLER);
        }
        return result;
    }

    protected T getContainer(String containerUri) throws CascadeResourceNotFoundException {
        return (T)this.cachedRepositoryService.getResource(InputControlsContainer.class, containerUri);
    }

    @Override
    public List<ReportInputControl> getInputControlsStructure(String containerUri, Set<String> inputControlIds) throws CascadeResourceNotFoundException {
        return this.getInputControlsStructure(this.getContainer(containerUri), inputControlIds);
    }

    @Override
    public List<InputControlState> getValuesForInputControlsFromRawData(String containerUri, Set<String> inputControlIds, Map<String, String[]> requestParameters) throws CascadeResourceNotFoundException {
        return this.getValuesForInputControlsFromRawData(this.getContainer(containerUri), inputControlIds, requestParameters);
    }

    @Override
    public Map<String, Object> getTypedParameters(String containerUri, Map<String, String[]> requestParameters, boolean skipValidation) throws CascadeResourceNotFoundException, InputControlsValidationException {
        return this.getTypedParameters(this.getContainer(containerUri), requestParameters, skipValidation);
    }

    @Override
    public Map<String, String[]> formatTypedParameters(String containerUri, Map<String, Object> typedParameters) throws CascadeResourceNotFoundException {
        return this.formatTypedParameters(this.getContainer(containerUri), typedParameters);
    }
}

