/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GenericTypeProcessorRegistry {
    private static final Log log = LogFactory.getLog(GenericTypeProcessorRegistry.class);
    @Autowired
    private ApplicationContext context;
    private volatile Map<Class<?>, Map<String, Object>> processors = new HashMap();

    public <T> T getTypeProcessor(Class<?> typeToProcess, Class<T> processorType) {
        return this.getTypeProcessor(typeToProcess, processorType, (Boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getTypeProcessor(String typeToProcessName, Class<T> processorType, Boolean exceptionIfNotConfigured) {
        Map<String, Object> concreteProcessors = this.processors.get(processorType);
        if (concreteProcessors == null) {
            Map<Class<?>, Map<String, Object>> map = this.processors;
            synchronized (map) {
                concreteProcessors = this.processors.get(processorType);
                if (concreteProcessors == null) {
                    concreteProcessors = this.initializeProcessors(processorType);
                    this.processors.put(processorType, concreteProcessors);
                }
            }
        }
        if (exceptionIfNotConfigured.booleanValue() && !concreteProcessors.containsKey(typeToProcessName)) {
            throw new IllegalStateException("Processor of type " + processorType.getName() + " for class " + typeToProcessName + " not configured");
        }
        return (T)concreteProcessors.get(typeToProcessName);
    }

    public <T> T getTypeProcessor(Class<?> typeToProcess, Class<T> processorType, Boolean exceptionIfNotConfigured) {
        return this.getTypeProcessor(typeToProcess.getName(), processorType, exceptionIfNotConfigured);
    }

    protected Map<String, Object> initializeProcessors(Class<?> processorType) {
        HashMap<String, Object> processors;
        block3: {
            processors = new HashMap<String, Object>();
            String[] dataConvertersNames = this.context.getBeanNamesForType(processorType);
            if (dataConvertersNames == null || dataConvertersNames.length <= 0) break block3;
            for (String dataConverterBeanName : dataConvertersNames) {
                Class valueClass;
                Object currentDataConverter;
                block4: {
                    Type[] genericInterfaces;
                    block5: {
                        Type[] bounds;
                        Type genericSuperclassType;
                        block6: {
                            currentDataConverter = this.context.getBean(dataConverterBeanName, processorType);
                            valueClass = null;
                            genericInterfaces = currentDataConverter.getClass().getGenericInterfaces();
                            if (genericInterfaces == null) break block4;
                            if (genericInterfaces.length != 0) break block5;
                            Type genericSuperclass = currentDataConverter.getClass().getGenericSuperclass();
                            if (!(genericSuperclass instanceof ParameterizedType)) break block4;
                            genericSuperclassType = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
                            if (!(genericSuperclassType instanceof Class)) break block6;
                            valueClass = (Class)genericSuperclassType;
                            break block4;
                        }
                        if (!(genericSuperclassType instanceof TypeVariable) || (bounds = ((TypeVariable)genericSuperclassType).getBounds()) == null || bounds.length <= 0 || !(bounds[0] instanceof Class)) break block4;
                        valueClass = (Class)bounds[0];
                        break block4;
                    }
                    for (Type currentType : genericInterfaces) {
                        if (!(currentType instanceof ParameterizedType) || ((ParameterizedType)currentType).getRawType() != processorType) continue;
                        valueClass = this.getValueClass(currentType);
                    }
                }
                if (valueClass == null) {
                    log.warn((Object)("Unable to find generic type of bean '" + dataConverterBeanName + "' (bean class " + currentDataConverter.getClass() + ")"));
                    continue;
                }
                processors.put(valueClass.getName(), currentDataConverter);
            }
        }
        return processors;
    }

    protected Class<?> getValueClass(Type type) {
        Class<?> valueClass = null;
        if (type instanceof ParameterizedType) {
            Type nextType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (nextType instanceof WildcardType) {
                type = ((ParameterizedType)type).getRawType();
            } else {
                valueClass = this.getValueClass(nextType);
            }
        }
        if (type instanceof Class) {
            valueClass = (Class<?>)type;
        }
        if (type instanceof TypeVariable) {
            valueClass = this.getValueClass(((TypeVariable)type).getBounds()[0]);
        }
        return valueClass;
    }
}

