/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.token;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.war.cascade.token.FilterResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FilterCore
implements FilterResolver,
Serializable {
    private static Logger log = Logger.getLogger(FilterCore.class);
    List builtInParameterProviders;

    public List getBuiltInParameterProviders() {
        return this.builtInParameterProviders;
    }

    public void setBuiltInParameterProviders(List builtInParameterProviders) {
        this.builtInParameterProviders = builtInParameterProviders;
    }

    @Override
    public boolean hasParameters(String queryString, Map parameters) {
        return this.hasParameters(queryString, 0);
    }

    public boolean hasParameters(String queryString, int start) {
        return this.nextParameter(queryString, start) != null;
    }

    private Parameter nextParameter(String queryString, int start) {
        if (start < 0 && start > queryString.length() - 1) {
            return null;
        }
        Matcher m = ParameterTypes.pattern.matcher(queryString);
        Parameter p = null;
        if (m.find(start) && (p = this.createParameter(m.group(1), m.group(2))) != null) {
            p.setStartPosition(m.start());
            p.setEndPosition(m.end());
        }
        return p;
    }

    private Parameter createParameter(String parameterType, String parameterContent) {
        Parameter p = null;
        ParameterTypes type = ParameterTypes.value(parameterType);
        if (ParameterTypes.P.equals((Object)type) || ParameterTypes.P_INC.equals((Object)type)) {
            p = this.createPParameter(parameterContent);
        } else if (ParameterTypes.X.equals((Object)type)) {
            p = this.createXParameter(parameterContent);
        }
        return p;
    }

    private Parameter createPParameter(String parameterContent) {
        Parameter p = new Parameter();
        p.addParameterName(parameterContent.trim());
        return p;
    }

    private Parameter createXParameter(String parameterContent) {
        Parameter p = new Parameter();
        String[] parts = parameterContent.split(",");
        for (int i = 2; i < parts.length; ++i) {
            p.addParameterName(parts[i].trim());
        }
        return p;
    }

    public List<Parameter> getParameters(String queryString) {
        Parameter p;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (queryString == null) {
            return parameters;
        }
        int index = 0;
        while (index < queryString.length() && this.hasParameters(queryString, index) && (p = this.nextParameter(queryString, index)) != null) {
            index = p.getEndPosition() + 1;
            if (p.getStartPosition() > 0 && queryString.charAt(p.getStartPosition() - 1) == '$') continue;
            parameters.add(p);
        }
        return parameters;
    }

    @Override
    public Set<String> getParameterNames(String queryString, Map<String, Object> providedParameters) {
        LinkedHashSet<String> parameterNames = new LinkedHashSet<String>();
        for (Parameter p : this.getParameters(queryString)) {
            parameterNames.addAll(p.getParameterNames());
        }
        return parameterNames;
    }

    @Override
    public Object getCacheKey(String queryString, Map<String, Object> providedParameters) {
        Map<String, Object> resolvedParameters = this.resolveParameters(queryString, providedParameters);
        if (resolvedParameters != null && queryString != null && !queryString.isEmpty()) {
            StringBuilder sb = new StringBuilder(queryString);
            if (!resolvedParameters.isEmpty()) {
                sb.append("; ").append(this.getString(resolvedParameters));
            }
            return sb.toString();
        }
        return null;
    }

    protected String getString(Map<String, Object> parameters) {
        StringBuilder map = new StringBuilder().append("{");
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (map.length() > 1) {
                map.append(", ");
            }
            map.append(entry.getKey()).append("=");
            if (entry.getValue() instanceof Collection) {
                StringBuilder list = new StringBuilder().append("[");
                for (Object value : (Collection)entry.getValue()) {
                    if (list.length() > 1) {
                        list.append(", ");
                    }
                    list.append((CharSequence)this.getString(value));
                }
                list.append("]");
                map.append((CharSequence)list);
                continue;
            }
            map.append((CharSequence)this.getString(entry.getValue()));
        }
        return map.append("}").toString();
    }

    protected StringBuilder getString(Object o) {
        StringBuilder sb = new StringBuilder();
        if (o != null) {
            sb.append("\"").append(String.valueOf(o)).append("\"");
        } else {
            sb.append(String.valueOf(o));
        }
        return sb;
    }

    @Override
    public Map<String, Object> resolveParameters(String queryString, Map<String, Object> providedParameters) {
        Set<String> queryParameterNames = this.getParameterNames(queryString, providedParameters);
        LinkedHashMap<String, Object> allParams = new LinkedHashMap<String, Object>(providedParameters != null ? providedParameters : Collections.EMPTY_MAP);
        Map<String, Object> resolvedBuildInParams = this.resolveBuiltInParameters(queryParameterNames);
        allParams.putAll(resolvedBuildInParams);
        LinkedHashMap<String, Object> resolvedParams = new LinkedHashMap<String, Object>();
        LinkedHashSet<String> missingQueryParameterNames = new LinkedHashSet<String>();
        for (String parameterName : queryParameterNames) {
            if (allParams.containsKey(parameterName)) {
                resolvedParams.put(parameterName, allParams.get(parameterName));
                continue;
            }
            missingQueryParameterNames.add(parameterName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("provided params: " + providedParameters));
            log.debug((Object)("resolved params: " + resolvedParams));
            log.debug((Object)("resolved build-in params: " + resolvedBuildInParams));
            log.debug((Object)("missing params: " + missingQueryParameterNames));
        }
        if (missingQueryParameterNames.size() > 0) {
            resolvedParams = null;
        }
        if (log.isDebugEnabled() && missingQueryParameterNames.size() > 0) {
            log.debug((Object)("final resolved params: " + resolvedParams));
        }
        return resolvedParams;
    }

    protected Map<String, Object> resolveBuiltInParameters(Set<String> queryParameterNames) {
        HashMap<String, Object> resolvedParams = new HashMap<String, Object>();
        if (queryParameterNames.size() > 0) {
            for (Object o : this.getBuiltInParameterProviders()) {
                BuiltInParameterProvider pProvider = (BuiltInParameterProvider)o;
                for (String name : queryParameterNames) {
                    Object[] aResult = pProvider.getParameter(null, null, null, name);
                    if (aResult == null) continue;
                    resolvedParams.put(name, aResult[1]);
                }
            }
        }
        return resolvedParams;
    }

    @Override
    public boolean paramTestNeedsDataSourceInit(ReportDataSource dataSource) {
        return false;
    }

    @Override
    public LinkedHashSet<String> resolveCascadingOrder(Map<String, Set<String>> masterDependencies) {
        LinkedList<String> orderedNames = new LinkedList<String>();
        LinkedList<String> workingQueue = new LinkedList<String>(masterDependencies.keySet());
        int maxIterations = masterDependencies.size() * (masterDependencies.size() + 1) / 2 + 1;
        while (workingQueue.size() > 0 && maxIterations-- > 0) {
            String currentName = (String)workingQueue.remove();
            Set<String> masterDependency = masterDependencies.get(currentName);
            if (masterDependency == null || masterDependency.isEmpty()) {
                orderedNames.addFirst(currentName);
                continue;
            }
            if (orderedNames.containsAll(masterDependency)) {
                orderedNames.addLast(currentName);
                continue;
            }
            workingQueue.add(currentName);
        }
        if (maxIterations > 0) {
            return new LinkedHashSet<String>(orderedNames);
        }
        throw new JSException("Order cannot be resolved because of circular or non-existing dependencies.");
    }

    private static class Parameter {
        private Set<String> parameterNames = new LinkedHashSet<String>();
        private int startPosition;
        private int endPosition;

        private Parameter() {
        }

        public Set<String> getParameterNames() {
            return this.parameterNames;
        }

        public void addParameterName(String name) {
            this.parameterNames.add(name);
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(int startPosition) {
            this.startPosition = startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(int endPosition) {
            this.endPosition = endPosition;
        }
    }

    public static enum ParameterTypes {
        P,
        P_INC("P!"),
        X;

        private String stringRepresentation;
        static Pattern pattern;

        private ParameterTypes() {
        }

        private ParameterTypes(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation != null ? this.stringRepresentation : super.toString();
        }

        public static ParameterTypes value(String rawValue) {
            return P_INC.toString().equals(rawValue) ? P_INC : ParameterTypes.valueOf(rawValue);
        }

        static {
            pattern = Pattern.compile("\\$(X|P|P!)\\{([^}]+)\\}");
        }
    }
}

