/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateSaveUpdateDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.war.themes.ThemeCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class ThemeHibernateListener
implements HibernateSaveUpdateDeleteListener,
BeanFactoryAware {
    private static Log log = LogFactory.getLog(ThemeHibernateListener.class);
    protected BeanFactory beanFactory;
    protected String themeCacheBeanName;
    protected ThemeCache themeCache;

    protected Log getLog() {
        return log;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public ThemeCache getThemeCache() {
        if (this.themeCache == null) {
            this.themeCache = (ThemeCache)this.beanFactory.getBean(this.themeCacheBeanName);
        }
        return this.themeCache;
    }

    protected void preProcessDelete(RepoResource res) {
    }

    protected void preProcessUpdate(RepoResource res) {
    }

    public void beforeSave(Object entity, HibernateTemplate hibernateTemplate) {
    }

    public void afterSave(Object entity, HibernateTemplate hibernateTemplate) {
        this.afterSaveOrUpdate(entity, hibernateTemplate);
    }

    public void beforeUpdate(Object entity, HibernateTemplate hibernateTemplate) {
    }

    public void afterUpdate(Object entity, HibernateTemplate hibernateTemplate) {
    }

    public void beforeSaveOrUpdate(Object entity, HibernateTemplate hibernateTemplate) {
    }

    public void afterSaveOrUpdate(Object entity, HibernateTemplate hibernateTemplate) {
        if (entity instanceof RepoResource) {
            RepoResource res = (RepoResource)entity;
            String uri = res.getResourceURI();
            if (this.getThemeCache().isThemeResource(uri)) {
                this.getLog().trace((Object)("onSaveOrUpdate: Resource :" + uri));
                this.preProcessUpdate(res);
                this.getThemeCache().onThemeResourceChanged(uri);
            }
        }
    }

    public void beforeDelete(Object entity, HibernateTemplate hibernateTemplate) {
        if (entity instanceof RepoResource) {
            RepoResource res = (RepoResource)entity;
            String uri = res.getResourceURI();
            if (this.getThemeCache().isThemeResource(uri)) {
                this.getLog().trace((Object)("onDelete: Resource :" + uri));
                this.preProcessDelete(res);
                this.getThemeCache().onThemeResourceChanged(uri);
            }
        }
    }

    public void afterDelete(Object entity, HibernateTemplate hibernateTemplate) {
    }

    public String getThemeCacheBeanName() {
        return this.themeCacheBeanName;
    }

    public void setThemeCacheBeanName(String themeCacheBeanName) {
        this.themeCacheBeanName = themeCacheBeanName;
    }
}

