/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThemeUtils {
    private static Log log = LogFactory.getLog(ThemeUtils.class);
    private ConfigurationBean configurationBean;
    private Pattern patternToFindTenantAndThemeByURI;
    private static final int TENANT_ID_GROUP = 1;
    private static final int TENANT_RELATIVE_URI_GROUP = 2;
    private static final int THEME_NAME_GROUP = 3;
    private static final int THEME_RELATIVE_URI_GROUP = 4;

    public ResourceInfo getResourceInfo(String resourceUri) {
        Matcher m = this.patternToFindTenantAndThemeByURI.matcher(resourceUri);
        if (m.matches()) {
            final String tenant = m.group(1);
            final String pathRelTenant = m.group(2);
            final String theme = m.group(3);
            final String pathRelTheme = theme != null ? m.group(4) : null;
            return new ResourceInfo(){

                @Override
                public String getTenantId() {
                    return tenant;
                }

                @Override
                public String getPathRelativeToTenant() {
                    return pathRelTenant;
                }

                @Override
                public String getThemeName() {
                    return theme;
                }

                @Override
                public String getPathRelativeToTheme() {
                    return pathRelTheme;
                }
            };
        }
        log.error((Object)("Invalid URI : " + resourceUri));
        throw new JSException("Invalid URI : " + resourceUri);
    }

    public ConfigurationBean getConfigurationBean() {
        return this.configurationBean;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
        this.patternToFindTenantAndThemeByURI = Pattern.compile("^(?:/organizations/([^/]+))*((?:" + configurationBean.getThemeFolderName() + "/([^/]+))?(/.*))");
    }

    public static interface ResourceInfo {
        public String getTenantId();

        public String getPathRelativeToTenant();

        public String getThemeName();

        public String getPathRelativeToTheme();
    }
}

