/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import com.jaspersoft.jasperserver.war.util.SessionObjectSeries;
import com.jaspersoft.jasperserver.war.util.SessionObjectSeriesListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.util.WebUtils;

public class LRUSessionObjectAccessor
implements SessionObjectSerieAccessor {
    protected static final Log log = LogFactory.getLog(LRUSessionObjectAccessor.class);
    private String listSessionName;
    private int maxSize;
    private SessionObjectSeriesListener listener;
    private AtomicInteger idCounter = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putObject(HttpServletRequest request, Object object) {
        ObjectSerie objectSerie = this.getObjectSerie(request);
        String name = this.createName(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.listSessionName + " putting object " + object + " with name " + name));
        }
        ObjectSerie objectSerie2 = objectSerie;
        synchronized (objectSerie2) {
            objectSerie.put(name, object);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(HttpServletRequest request, String name) {
        ObjectSerie objectSerie;
        ObjectSerie objectSerie2 = objectSerie = this.getObjectSerie(request);
        synchronized (objectSerie2) {
            Object object = objectSerie.get(name);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(HttpServletRequest request, String name) {
        ObjectSerie objectSerie;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.listSessionName + " removing object with name " + name));
        }
        ObjectSerie objectSerie2 = objectSerie = this.getObjectSerie(request);
        synchronized (objectSerie2) {
            objectSerie.remove(name);
        }
    }

    @Override
    public SessionObjectSeries getSeries(HttpSession session) {
        return this.getObjectSerie(session);
    }

    protected ObjectSerie getObjectSerie(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return this.getObjectSerie(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectSerie getObjectSerie(HttpSession session) {
        ObjectSerie serie;
        Object mutex = WebUtils.getSessionMutex((HttpSession)session);
        boolean created = false;
        Object object = mutex;
        synchronized (object) {
            serie = (ObjectSerie)session.getAttribute(this.getListSessionName());
            if (serie == null) {
                created = true;
                serie = new ObjectSerie(this.getMaxSize(), this.getListener());
                session.setAttribute(this.getListSessionName(), (Object)serie);
            }
        }
        if (created && log.isDebugEnabled()) {
            log.debug((Object)(this.listSessionName + " created object serie " + serie + " for session " + session.getId()));
        }
        return serie;
    }

    protected String createName(Object object) {
        return System.identityHashCode(object) + "_" + System.currentTimeMillis() + "_" + this.idCounter.getAndIncrement();
    }

    public String getListSessionName() {
        return this.listSessionName;
    }

    public void setListSessionName(String listSessionName) {
        this.listSessionName = listSessionName;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public SessionObjectSeriesListener getListener() {
        return this.listener;
    }

    public void setListener(SessionObjectSeriesListener listener) {
        this.listener = listener;
    }

    protected static class ObjectSerie
    extends LinkedHashMap
    implements SessionObjectSeries,
    HttpSessionBindingListener,
    HttpSessionActivationListener {
        private static final long serialVersionUID = 1L;
        private final int maxSize;
        private final SessionObjectSeriesListener listener;

        public ObjectSerie(int maxSize, SessionObjectSeriesListener listener) {
            this.maxSize = maxSize;
            this.listener = listener;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            boolean remove;
            boolean bl = remove = this.size() > this.maxSize;
            if (remove && log.isDebugEnabled()) {
                log.debug((Object)("Automatically removing object with name " + entry.getKey()));
            }
            return remove;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            if (this.listener != null) {
                this.listener.objectSeriesBound(event, this);
            }
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (this.listener != null) {
                this.listener.objectSeriesUnbound(event, this);
            }
        }

        public void sessionDidActivate(HttpSessionEvent se) {
            if (this.listener != null) {
                this.listener.objectSeriesDidActivate(se, this);
            }
        }

        public void sessionWillPassivate(HttpSessionEvent se) {
            if (this.listener != null) {
                this.listener.objectSeriesWillPassivate(se, this);
            }
        }

        @Override
        public List getValues() {
            Collection values = this.values();
            return new ArrayList(values);
        }
    }
}

