/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class SortedServletResourcePatternResolver
extends ServletContextResourcePatternResolver {
    private static final String NAME_SUFFIX = ".xml";
    private static final int NAME_SUFFIX_LENGTH = 4;
    private static final Comparator RESOURCE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String name2;
            String name1 = ((Resource)o1).getFilename();
            if (name1.endsWith(SortedServletResourcePatternResolver.NAME_SUFFIX)) {
                name1 = name1.substring(0, name1.length() - 4);
            }
            if ((name2 = ((Resource)o2).getFilename()).endsWith(SortedServletResourcePatternResolver.NAME_SUFFIX)) {
                name2 = name2.substring(0, name2.length() - 4);
            }
            return name1.compareTo(name2);
        }
    };

    public SortedServletResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Set doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        Set resources = super.doFindPathMatchingFileResources(rootDirResource, subPattern);
        if (resources != null && resources.size() > 1) {
            resources = this.sortResources(resources);
        }
        return resources;
    }

    protected Set sortResources(Set resourceSet) {
        ArrayList resourceList = new ArrayList(resourceSet);
        Collections.sort(resourceList, RESOURCE_COMPARATOR);
        LinkedHashSet sortedSet = new LinkedHashSet(resourceList);
        return sortedSet;
    }
}

