/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.webflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.View;

public class JsonModelView
implements View {
    private static final Log log = LogFactory.getLog(JsonModelView.class);
    private final String[] modelNames;

    public JsonModelView(String ... modelNames) {
        this.modelNames = modelNames;
    }

    public String getContentType() {
        return "application/json";
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"rendering json model view");
        }
        LinkedHashMap responseMap = new LinkedHashMap();
        for (String modelName : this.modelNames) {
            Object modelObject = model.get(modelName);
            if (modelObject == null) continue;
            responseMap.put(modelName, modelObject);
        }
        response.setContentType("application/json");
        ObjectMapper jsonMapper = new ObjectMapper();
        ServletOutputStream out = response.getOutputStream();
        jsonMapper.writeValue((OutputStream)out, responseMap);
    }
}

