/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.changeorder;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.changeorder.ChangeOrderModel;
import com.tonbeller.wcf.changeorder.DefaultChangeOrderModel;
import com.tonbeller.wcf.component.Form;
import com.tonbeller.wcf.component.RenderListener;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.utils.DomUtils;
import org.w3c.dom.Element;

public class ChangeOrderMgr
implements RenderListener {
    Dispatcher dispatcher = new DispatcherSupport();
    ChangeOrderModel model;
    static final String BUTTON_ELEMENT = "move-button";
    static final String STYLE_ATTR = "style";
    static final String STYLE_FWD = "fwd";
    static final String STYLE_BWD = "bwd";
    static final String STYLE_CUT = "cut";
    static final String STYLE_UNCUT = "uncut";
    static final String STYLE_PASTE_BEFORE = "paste-before";
    static final String STYLE_PASTE_AFTER = "paste-after";
    static final String TITLE_ATTR = "title";
    String titleFwd = "";
    String titleBwd = "";
    String titleCut = "";
    String titleUncut = "";
    String titlePasteBefore = "";
    String titlePasteAfter = "";
    Form form;
    ButtonRenderer buttonRenderer = new ForwardBackwardButtonRenderer();

    public ChangeOrderMgr(Dispatcher parentDispatcher, Form form) {
        this.form = form;
        this.model = new DefaultChangeOrderModel();
        parentDispatcher.addRequestListener(null, null, this.dispatcher);
    }

    public ChangeOrderMgr(Dispatcher parentDispatcher, Form form, ChangeOrderModel model) {
        this.form = form;
        this.model = model;
        parentDispatcher.addRequestListener(null, null, this.dispatcher);
    }

    public void renderButton(Element elem, Object scope, Object node, int nodeIndex, int nodeCount) {
        if (this.model == null || !this.model.mayMove(scope, node)) {
            return;
        }
        if (nodeCount < 2) {
            return;
        }
        this.buttonRenderer.renderButton(elem, scope, node, nodeIndex, nodeCount);
    }

    public void startRendering(RequestContext context) {
        Resources res = Resources.instance();
        if (res == null) {
            res = context.getResources(ChangeOrderMgr.class);
        }
        this.titleFwd = res.getString("jsp.wcf.ChangeOrderMgr.titleFwd");
        this.titleBwd = res.getString("jsp.wcf.ChangeOrderMgr.titleBwd");
        this.titleCut = res.getString("jsp.wcf.ChangeOrderMgr.titleCut");
        this.titleUncut = res.getString("jsp.wcf.ChangeOrderMgr.titleUncut");
        this.titlePasteBefore = res.getString("jsp.wcf.ChangeOrderMgr.titlePasteBefore");
        this.titlePasteAfter = res.getString("jsp.wcf.ChangeOrderMgr.titlePasteAfter");
        this.dispatcher.clear();
        this.buttonRenderer.startRendering(context);
    }

    public void stopRendering() {
        this.buttonRenderer.stopRendering();
    }

    public ChangeOrderModel getModel() {
        return this.model;
    }

    public void setModel(ChangeOrderModel model) {
        this.model = model;
    }

    public void setCutPasteMode(boolean b) {
        this.buttonRenderer = b ? new CutButtonRenderer() : new ForwardBackwardButtonRenderer();
    }

    class ChangeOrderButtonHandler
    implements RequestListener {
        Object scope;
        Object item;
        int oldIndex;
        int newIndex;

        ChangeOrderButtonHandler(Object scope, Object item, int oldIndex, int newIndex) {
            this.scope = scope;
            this.item = item;
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            ChangeOrderMgr.this.form.validate(context);
            if (ChangeOrderMgr.this.model != null) {
                ChangeOrderMgr.this.model.move(this.scope, this.item, this.oldIndex, this.newIndex);
            }
        }
    }

    class UnCutButtonHandler
    implements RequestListener {
        UnCutButtonHandler() {
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            ChangeOrderMgr.this.form.validate(context);
            ChangeOrderMgr.this.buttonRenderer = new CutButtonRenderer();
        }
    }

    class PasteButtonRenderer
    implements ButtonRenderer {
        Object scope;
        Object item;
        int nodeIndex;

        PasteButtonRenderer(Object scope, Object item, int nodeIndex) {
            this.scope = scope;
            this.item = item;
            this.nodeIndex = nodeIndex;
        }

        boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }

        public void renderButton(Element elem, Object scope, Object item, int nodeIndex, int nodeCount) {
            if (!this.equals(this.scope, scope)) {
                return;
            }
            Element buttonElem = elem.getOwnerDocument().createElement(ChangeOrderMgr.BUTTON_ELEMENT);
            elem.appendChild(buttonElem);
            String id = DomUtils.randomId();
            buttonElem.setAttribute("id", id);
            if (this.nodeIndex == nodeIndex) {
                buttonElem.setAttribute(ChangeOrderMgr.STYLE_ATTR, ChangeOrderMgr.STYLE_UNCUT);
                buttonElem.setAttribute(ChangeOrderMgr.TITLE_ATTR, ChangeOrderMgr.this.titleUncut);
                ChangeOrderMgr.this.dispatcher.addRequestListener(id, null, new UnCutButtonHandler());
            } else if (this.nodeIndex < nodeIndex) {
                buttonElem.setAttribute(ChangeOrderMgr.STYLE_ATTR, ChangeOrderMgr.STYLE_PASTE_AFTER);
                buttonElem.setAttribute(ChangeOrderMgr.TITLE_ATTR, ChangeOrderMgr.this.titlePasteAfter);
                ChangeOrderMgr.this.dispatcher.addRequestListener(id, null, new ChangeOrderButtonHandler(scope, item, this.nodeIndex, nodeIndex));
            } else {
                buttonElem.setAttribute(ChangeOrderMgr.STYLE_ATTR, ChangeOrderMgr.STYLE_PASTE_BEFORE);
                buttonElem.setAttribute(ChangeOrderMgr.TITLE_ATTR, ChangeOrderMgr.this.titlePasteBefore);
                ChangeOrderMgr.this.dispatcher.addRequestListener(id, null, new ChangeOrderButtonHandler(scope, item, this.nodeIndex, nodeIndex));
            }
        }

        public void startRendering(RequestContext context) {
        }

        public void stopRendering() {
            ChangeOrderMgr.this.buttonRenderer = new CutButtonRenderer();
        }
    }

    class CutButtonHandler
    implements RequestListener {
        Object scope;
        Object item;
        int nodeIndex;

        CutButtonHandler(Object scope, Object item, int nodeIndex) {
            this.scope = scope;
            this.item = item;
            this.nodeIndex = nodeIndex;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            ChangeOrderMgr.this.form.validate(context);
            if (ChangeOrderMgr.this.model != null) {
                ChangeOrderMgr.this.buttonRenderer = new PasteButtonRenderer(this.scope, this.item, this.nodeIndex);
            }
        }
    }

    class CutButtonRenderer
    implements ButtonRenderer {
        CutButtonRenderer() {
        }

        public void renderButton(Element elem, Object scope, Object item, int nodeIndex, int nodeCount) {
            Element buttonElem = elem.getOwnerDocument().createElement(ChangeOrderMgr.BUTTON_ELEMENT);
            elem.appendChild(buttonElem);
            buttonElem.setAttribute(ChangeOrderMgr.STYLE_ATTR, ChangeOrderMgr.STYLE_CUT);
            buttonElem.setAttribute(ChangeOrderMgr.TITLE_ATTR, ChangeOrderMgr.this.titleCut);
            String id = DomUtils.randomId();
            buttonElem.setAttribute("id", id);
            ChangeOrderMgr.this.dispatcher.addRequestListener(id, null, new CutButtonHandler(scope, item, nodeIndex));
        }

        public void startRendering(RequestContext context) {
        }

        public void stopRendering() {
        }
    }

    class ForwardBackwardButtonRenderer
    implements ButtonRenderer {
        ForwardBackwardButtonRenderer() {
        }

        public void renderButton(Element elem, Object scope, Object node, int nodeIndex, int nodeCount) {
            if (nodeIndex == 0) {
                if (nodeCount > 2) {
                    this.appendEmptyButton(elem);
                }
                this.appendMoveButton(elem, scope, node, ChangeOrderMgr.STYLE_FWD, ChangeOrderMgr.this.titleFwd, nodeIndex, nodeIndex + 1);
            } else if (nodeIndex == nodeCount - 1) {
                this.appendMoveButton(elem, scope, node, ChangeOrderMgr.STYLE_BWD, ChangeOrderMgr.this.titleBwd, nodeIndex, nodeIndex - 1);
                if (nodeCount > 2) {
                    this.appendEmptyButton(elem);
                }
            } else {
                this.appendMoveButton(elem, scope, node, ChangeOrderMgr.STYLE_BWD, ChangeOrderMgr.this.titleBwd, nodeIndex, nodeIndex - 1);
                this.appendMoveButton(elem, scope, node, ChangeOrderMgr.STYLE_FWD, ChangeOrderMgr.this.titleFwd, nodeIndex, nodeIndex + 1);
            }
        }

        public void startRendering(RequestContext context) {
        }

        public void stopRendering() {
        }

        void appendEmptyButton(Element elem) {
            Element buttonElem = elem.getOwnerDocument().createElement(ChangeOrderMgr.BUTTON_ELEMENT);
            elem.appendChild(buttonElem);
        }

        void appendMoveButton(Element elem, Object scope, Object item, String style, String title, int oldIndex, int newIndex) {
            Element buttonElem = elem.getOwnerDocument().createElement(ChangeOrderMgr.BUTTON_ELEMENT);
            elem.appendChild(buttonElem);
            buttonElem.setAttribute(ChangeOrderMgr.STYLE_ATTR, style);
            buttonElem.setAttribute(ChangeOrderMgr.TITLE_ATTR, title);
            String id = DomUtils.randomId();
            buttonElem.setAttribute("id", id);
            ChangeOrderMgr.this.dispatcher.addRequestListener(id, null, new ChangeOrderButtonHandler(scope, item, oldIndex, newIndex));
        }
    }

    static interface ButtonRenderer
    extends RenderListener {
        public void renderButton(Element var1, Object var2, Object var3, int var4, int var5);
    }
}

