/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.tbutils.res.ResourcesFactory;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactory;
import com.tonbeller.wcf.controller.RequestContextImpl;
import com.tonbeller.wcf.convert.Converter;
import com.tonbeller.wcf.convert.ConverterFactory;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.format.FormatterFactory;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;

public class RequestContextFactoryImpl
implements RequestContextFactory {
    Formatter formatter;
    Converter converter;
    Locale locale;
    Resources resources;
    String remoteUser;
    String remoteDomain;
    private static Logger logger = Logger.getLogger(RequestContextFactoryImpl.class);

    public RequestContext createContext(HttpServletRequest request, HttpServletResponse response) {
        this.initialize(request);
        return new RequestContextImpl(this, request, response);
    }

    protected void initialize(HttpServletRequest request) {
        if (this.locale == null) {
            this.locale = (Locale)request.getSession().getAttribute("userLocale");
            if (this.locale == null) {
                this.locale = ResourcesFactory.instance().getFixedLocale();
            }
            if (this.locale == null) {
                this.locale = request.getLocale();
            }
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            this.formatter = FormatterFactory.instance(this.locale);
            this.converter = ConverterFactory.instance(this.formatter);
            this.resources = Resources.instance(this.locale, this.getClass());
            String rUser = request.getRemoteUser();
            if (rUser != null) {
                int slash = rUser.indexOf(47);
                if (slash >= 0) {
                    this.remoteDomain = rUser.substring(0, slash);
                    this.remoteUser = rUser.substring(slash + 1);
                } else {
                    this.remoteUser = rUser;
                    this.remoteDomain = null;
                }
                if (this.remoteUser != null) {
                    this.remoteUser = this.remoteUser.trim();
                }
                if (this.remoteDomain != null) {
                    this.remoteDomain = this.remoteDomain.trim();
                }
            }
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (locale != null) {
            this.formatter = FormatterFactory.instance(locale);
            this.converter = ConverterFactory.instance(this.formatter);
            this.resources = Resources.instance(locale, this.getClass());
        }
    }

    public void setLocale(HttpServletRequest request, Locale locale) {
        this.locale = locale;
        if (locale != null) {
            this.formatter = FormatterFactory.instance(locale);
            this.converter = ConverterFactory.instance(this.formatter);
            this.resources = Resources.instance(locale, this.getClass());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("setting locale to " + locale));
            }
            Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        }
    }

    public Converter getConverter() {
        return this.converter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getRemoteDomain() {
        return this.remoteDomain;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }
}

