/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.convert;

import com.tonbeller.wcf.convert.ConvertException;
import com.tonbeller.wcf.convert.Converter;
import com.tonbeller.wcf.convert.NodeConverter;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.SoftException;
import com.tonbeller.wcf.utils.XmlUtils;
import com.tonbeller.wcf.utils.XoplonNS;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterImpl
implements Converter {
    HashMap handlers = new HashMap();
    Formatter formatter;
    FormatException formatException = null;
    private static Logger logger = Logger.getLogger(ConverterImpl.class);

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public void addHandler(NodeConverter nc) {
        this.handlers.put(nc.getElementName(), nc);
    }

    public void validate(Map params, Map fileParams, Node node, Object bean) throws ConvertException, FormatException {
        try {
            this.formatException = null;
            Document root = XmlUtils.getDocument(node);
            this.traverse(node, params, fileParams, bean);
            if (this.formatException != null) {
                throw this.formatException;
            }
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
    }

    void traverse(Node node, Map params, Map fileParams, Object bean) throws ConvertException, IllegalAccessException, NoSuchMethodException {
        if (node.getNodeType() == 1) {
            String name = node.getNodeName();
            NodeConverter handler = (NodeConverter)this.handlers.get(name);
            Element elem = (Element)node;
            if (this.ignoreAll(elem)) {
                return;
            }
            if (handler != null) {
                try {
                    handler.convert(this.formatter, params, fileParams, elem, bean);
                }
                catch (FormatException e) {
                    this.formatException = e;
                    XoplonNS.setAttribute(elem, "error", this.formatException.getMessage());
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof FormatException) {
                        this.formatException = (FormatException)te;
                        XoplonNS.setAttribute(elem, "error", this.formatException.getMessage());
                    }
                    if (te instanceof IllegalArgumentException) {
                        this.formatException = new FormatException(te.getMessage());
                        XoplonNS.setAttribute(elem, "error", this.formatException.getMessage());
                    }
                    throw new SoftException(te);
                }
            }
        }
        List children = DomUtils.getChildElements(node);
        for (Element child : children) {
            this.traverse(child, params, fileParams, bean);
        }
    }

    private boolean ignoreAll(Element elem) {
        if (XoplonCtrl.isHidden(elem)) {
            return true;
        }
        return "true".equals(elem.getAttribute("children-hidden"));
    }

    public void revert(Object bean, Node node) throws ConvertException {
        try {
            this.formatException = null;
            this.traverse(node, bean);
            if (this.formatException != null) {
                throw this.formatException;
            }
        }
        catch (IllegalAccessException e) {
            throw new SoftException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SoftException(e);
        }
        catch (InvocationTargetException e) {
            throw new SoftException(e);
        }
    }

    void traverse(Node node, Object bean) throws ConvertException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (node.getNodeType() == 1) {
            String name = node.getNodeName();
            Element elem = (Element)node;
            if (this.ignoreAll(elem)) {
                return;
            }
            NodeConverter handler = (NodeConverter)this.handlers.get(name);
            if (handler != null) {
                DomUtils.removeAttribute(elem, "error");
                try {
                    handler.convert(this.formatter, bean, elem);
                }
                catch (FormatException e) {
                    this.formatException = e;
                }
            }
        }
        List children = DomUtils.getChildElements(node);
        for (Element child : children) {
            this.traverse(child, bean);
        }
    }
}

