/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.sqltable;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.sqltable.SqlTable;
import com.tonbeller.wcf.sqltable.SqlTableNestedTag;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.log4j.Logger;

public class SqlTablePageNavigationsTag
extends SqlTableNestedTag {
    String resultExpr;
    private static Logger logger = Logger.getLogger(SqlTablePageNavigationsTag.class);

    public int doStartTag() throws JspException {
        RequestListener r;
        if (!this.isRenderActions()) {
            return 0;
        }
        SqlTable table = this.getTable();
        int startRow = table.getStartRow();
        int maxRows = table.getMaxRows();
        if (maxRows <= 0) {
            return 0;
        }
        Resources res = this.getResources();
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        String tableId = table.getId();
        String curPage = Integer.toString(startRow / maxRows + 1);
        String pageSize = Integer.toString(maxRows);
        Object[] args = new Object[]{contextPath, tableId, curPage, pageSize};
        boolean havePrevious = false;
        String prevButton = "";
        if (table.getStartRow() > 0) {
            prevButton = res.getString("jsp.wcf.sqltable.page.button.prev", args);
            PrevButton r2 = new PrevButton(table);
            table.addRequestListener(table.getId() + ".prev", null, r2);
            havePrevious = true;
        }
        boolean haveNext = false;
        String nextButton = "";
        Result result = (Result)ExprUtils.getModelReference(this.pageContext, this.resultExpr);
        if (result.isLimitedByMaxRows()) {
            nextButton = res.getString("jsp.wcf.sqltable.page.button.next", args);
            r = new NextButton(table);
            table.addRequestListener(table.getId() + ".next", null, r);
            haveNext = true;
        }
        r = new GotoButton(table);
        table.addRequestListener(table.getId() + ".goto.button", null, r);
        r = new PageSizeButton(table);
        table.addRequestListener(table.getId() + ".size.button", null, r);
        String show = res.getString("jsp.wcf.sqltable.page.show", args);
        String go = res.getString("jsp.wcf.sqltable.page.goto", args);
        String size = res.getString("jsp.wcf.sqltable.page.size", args);
        try {
            JspWriter out = this.pageContext.getOut();
            if (havePrevious) {
                out.print(prevButton);
                out.print(" ");
            }
            if (havePrevious || haveNext) {
                out.print(show);
                out.print(" ");
            }
            if (haveNext) {
                out.print(nextButton);
                out.print(" ");
            }
            if (havePrevious || haveNext) {
                out.print(go);
                out.print(" ");
            }
            this.pageContext.getOut().print(size);
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        return 0;
    }

    public void setResult(String result) {
        this.resultExpr = result;
    }

    static class PageSizeButton
    implements RequestListener {
        private SqlTable table;

        PageSizeButton(SqlTable table) {
            this.table = table;
        }

        public void request(RequestContext context) throws Exception {
            int size;
            Scroller.enableScroller(context);
            String value = context.getParameter(this.table.getId() + ".size.value");
            if (value == null) {
                return;
            }
            try {
                size = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (size > 0) {
                this.table.setMaxRows(size);
                this.table.setStartRow(0);
            }
        }
    }

    static class GotoButton
    extends PageButton {
        public GotoButton(SqlTable table) {
            super(table);
        }

        protected int getStartRow(RequestContext context) {
            int page;
            String value = context.getParameter(this.table.getId() + ".goto.value");
            if (value == null) {
                return 0;
            }
            try {
                page = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
            return (page - 1) * this.table.getMaxRows();
        }
    }

    static class NextButton
    extends PageButton {
        public NextButton(SqlTable table) {
            super(table);
        }

        protected int getStartRow(RequestContext context) {
            return this.table.getStartRow() + this.table.getMaxRows();
        }
    }

    static class PrevButton
    extends PageButton {
        public PrevButton(SqlTable table) {
            super(table);
        }

        protected int getStartRow(RequestContext context) {
            return this.table.getStartRow() - this.table.getMaxRows();
        }
    }

    static abstract class PageButton
    implements RequestListener {
        protected SqlTable table;

        protected abstract int getStartRow(RequestContext var1);

        PageButton(SqlTable table) {
            this.table = table;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            int maxRows = this.table.getMaxRows();
            if (maxRows < 0) {
                this.table.setStartRow(0);
                return;
            }
            int startRow = this.getStartRow(context);
            if (startRow < 0) {
                startRow = 0;
            }
            this.table.setStartRow(startRow);
        }
    }
}

