/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.form.FormDocument;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.table.ITableComponent;
import com.tonbeller.wcf.table.RowComparator;
import com.tonbeller.wcf.table.TableComponent;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.table.TablePropertiesFormComponent;
import com.tonbeller.wcf.utils.I18nReplacer;
import com.tonbeller.wcf.utils.ResourceLocator;
import com.tonbeller.wcf.utils.SoftException;
import com.tonbeller.wcf.utils.XmlUtils;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import org.springframework.context.i18n.LocaleContextHolder;
import org.w3c.dom.Document;

public class EditableTableComponent
extends ComponentSupport
implements ITableComponent {
    TableComponent tableComp;
    TablePropertiesFormComponent formComp;
    String editButtonId;
    String csvButtonId;
    boolean editable = true;
    RequestListener editButtonListener = new RequestListener(){

        public void request(RequestContext context) throws Exception {
            EditableTableComponent.this.tableComp.validate(context);
            EditableTableComponent.this.formComp.setVisible(true);
        }
    };

    public EditableTableComponent(String id, Component parent, TableComponent tableComp, TablePropertiesFormComponent formComp) {
        super(id, parent);
        this.tableComp = tableComp;
        this.formComp = formComp;
        tableComp.setParent(this);
        formComp.setParent(this);
        this.addFormListener(tableComp);
        this.addFormListener(formComp);
        this.editButtonId = id + ".edit";
        this.csvButtonId = id + ".csv";
        this.getDispatcher().addRequestListener(this.editButtonId, null, this.editButtonListener);
    }

    public static EditableTableComponent instance(RequestContext context, String id, TableComponent table) {
        URL url;
        String path;
        Locale locale = LocaleContextHolder.getLocale();
        if (locale == null) {
            locale = context.getLocale();
        }
        if ((path = Resources.instance().getString("jsp.wcf.table.editform")) == null) {
            ResourceBundle resb = ResourceBundle.getBundle("com.tonbeller.wcf.table.resources", locale);
            path = resb.getString("jsp.wcf.table.editform");
        }
        try {
            url = ResourceLocator.getResource(context.getServletContext(), locale, path);
        }
        catch (Exception e) {
            throw new SoftException(e);
        }
        Document doc = XmlUtils.parse(url);
        I18nReplacer replacer = I18nReplacer.instance(Resources.instance());
        if (replacer != null) {
            replacer.replaceAll(doc);
        } else {
            FormDocument.replaceI18n(context, doc, null);
        }
        TablePropertiesFormComponent formComp = new TablePropertiesFormComponent(id + ".form", null, doc, table);
        formComp.setVisible(false);
        formComp.setCloseable(true);
        return new EditableTableComponent(id, null, table, formComp);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.tableComp.initialize(context);
        this.formComp.initialize(context);
    }

    public void destroy(HttpSession session) throws Exception {
        this.formComp.destroy(session);
        this.tableComp.destroy(session);
        super.destroy(session);
    }

    public Document render(RequestContext context) throws Exception {
        if (this.isEditFormVisible()) {
            return this.formComp.render(context);
        }
        Document doc = this.tableComp.render(context);
        I18nReplacer replacer = I18nReplacer.instance(Resources.instance());
        if (replacer != null) {
            replacer.replaceAll(doc);
        } else {
            FormDocument.replaceI18n(context, doc, null);
        }
        if (this.editable) {
            Resources resources = Resources.instance();
            doc.getDocumentElement().setAttribute("editId", this.editButtonId);
            doc.getDocumentElement().setAttribute("editTitle", resources.getResourceBundle().getMessage("JAJ_000_jsp.wcf.editProperties", null, resources.getLocaleContextHolderLocale()));
            doc.getDocumentElement().setAttribute("csvId", this.csvButtonId);
            doc.getDocumentElement().setAttribute("csvTitle", resources.getResourceBundle().getMessage("JAJ_000_jsp.wcf.csvProperties", null, resources.getLocaleContextHolderLocale()));
        }
        return doc;
    }

    public boolean isVisible() {
        return this.tableComp.isVisible();
    }

    public void setVisible(boolean b) {
        this.tableComp.setVisible(b);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public boolean isEditFormVisible() {
        return this.formComp.isVisible();
    }

    public String getBorder() {
        return this.tableComp.getBorder();
    }

    public int getCurrentPage() {
        return this.tableComp.getCurrentPage();
    }

    public TableModel getModel() {
        return this.tableComp.getModel();
    }

    public int getPageCount() {
        return this.tableComp.getPageCount();
    }

    public int getPageSize() {
        return this.tableComp.getPageSize();
    }

    public String getRenderId() {
        return this.tableComp.getRenderId();
    }

    public RowComparator getRowComparator() {
        return this.tableComp.getRowComparator();
    }

    public SelectionModel getSelectionModel() {
        return this.tableComp.getSelectionModel();
    }

    public boolean isClosable() {
        return this.tableComp.isClosable();
    }

    public boolean isPageable() {
        return this.tableComp.isPageable();
    }

    public boolean isSortable() {
        return this.tableComp.isSortable();
    }

    public void setBorder(String border) {
        this.tableComp.setBorder(border);
    }

    public void setClosable(boolean b) {
        this.tableComp.setClosable(b);
    }

    public void setCurrentPage(int newCurrentPage) {
        this.tableComp.setCurrentPage(newCurrentPage);
    }

    public void setError(String message) {
        this.tableComp.setError(message);
    }

    public void setModel(TableModel newModel) {
        this.tableComp.setModel(newModel);
        this.formComp.columnTreeModelChanged();
    }

    public void setPageable(boolean newPageable) {
        this.tableComp.setPageable(newPageable);
    }

    public void setPageSize(int newPageSize) {
        this.tableComp.setPageSize(newPageSize);
    }

    public void setRenderId(String renderId) {
        this.tableComp.setRenderId(renderId);
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.tableComp.setSelectionModel(selectionModel);
    }

    public void setSortable(boolean newSortable) {
        this.tableComp.setSortable(newSortable);
    }

    public void setSortColumnIndex(int index) {
        this.tableComp.setSortColumnIndex(index);
    }

    public TableComponent getTableComp() {
        return this.tableComp;
    }

    public boolean isReadOnly() {
        return this.tableComp.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.tableComp.setReadOnly(readOnly);
    }
}

