/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.selection.Unselectable;
import com.tonbeller.wcf.tree.LabelProvider;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.tree.TreeModelDecorator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class GroupingTreeModelDecorator
extends TreeModelDecorator {
    private int limit;
    private LabelProvider labelProvider;
    private Map mapChild2Parent;
    private Map mapParent2Children;
    private MessageFormat format;
    private static final Object NULL = new Object();
    TreeModelChangeListener listener = new TreeModelChangeListener(){

        public void treeModelChanged(TreeModelChangeEvent event) {
            if (event.getSubtree() != null) {
                GroupingTreeModelDecorator.this.invalidateSubtree(event.getSubtree());
            } else {
                GroupingTreeModelDecorator.this.mapChild2Parent.clear();
                GroupingTreeModelDecorator.this.mapParent2Children.clear();
            }
        }
    };

    public GroupingTreeModelDecorator(LabelProvider labelProvider, TreeModel decoree, int limit) {
        super(decoree);
        this.mapChild2Parent = new HashMap();
        this.mapParent2Children = new HashMap();
        this.initialize(labelProvider, limit);
    }

    public GroupingTreeModelDecorator(Comparator nodeComparator, LabelProvider labelProvider, TreeModel decoree, int limit) {
        super(decoree);
        GroupComparator comp = new GroupComparator(nodeComparator);
        this.mapChild2Parent = new TreeMap(comp);
        this.mapParent2Children = new TreeMap(comp);
        this.initialize(labelProvider, limit);
    }

    private void invalidateSubtree(Object parent) {
        Object[] children = (Object[])this.mapParent2Children.remove(parent);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.mapChild2Parent.remove(children[i]);
                this.invalidateSubtree(children[i]);
            }
        }
    }

    private void initialize(LabelProvider labelProvider, int limit) {
        this.limit = limit;
        this.labelProvider = labelProvider;
        super.getDecoree().addTreeModelChangeListener(this.listener);
        RequestContext ctx = RequestContext.instance(false);
        if (ctx != null) {
            Resources res = ctx.getResources(GroupingTreeModelDecorator.class);
            String fmt = res.getString("wcf.GroupingTreeModelDecorator.label.tree.group.label");
            Locale loc = res.getLocale();
            this.format = new MessageFormat(fmt, loc);
        } else {
            this.format = new MessageFormat("{0} ...");
        }
    }

    private void updateCache(Object parent, Object[] children) {
        if (parent == null) {
            parent = NULL;
        }
        if (children != null) {
            this.mapParent2Children.put(parent, children);
            for (int i = 0; i < children.length; ++i) {
                this.mapChild2Parent.put(children[i], parent);
            }
        }
    }

    Object[] group(Object parent, Object[] children) {
        if (this.limit <= 0 || children.length <= this.limit) {
            this.updateCache(parent, children);
            return children;
        }
        int groupCount = (children.length + this.limit - 1) / this.limit;
        Object[] groups = new Group[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            int fromIndex = i * this.limit;
            int toIndex = (i + 1) * this.limit;
            if (toIndex > children.length) {
                toIndex = children.length;
            }
            int count = toIndex - fromIndex;
            Object[] arr = new Object[count];
            System.arraycopy(children, fromIndex, arr, 0, count);
            groups[i] = new Group(arr);
            this.updateCache(groups[i], arr);
        }
        this.updateCache(parent, groups);
        return this.group(parent, groups);
    }

    public Object[] getRoots() {
        Object[] roots = (Object[])this.mapParent2Children.get(NULL);
        if (roots != null) {
            return roots;
        }
        return this.group(NULL, super.getRoots());
    }

    public boolean hasChildren(Object node) {
        return node instanceof Group || super.hasChildren(node);
    }

    public Object[] getChildren(Object node) {
        Object[] children = (Object[])this.mapParent2Children.get(node);
        if (children != null) {
            return children;
        }
        return this.group(node, super.getChildren(node));
    }

    public Object getParent(Object node) {
        Object parent = this.mapChild2Parent.get(node);
        if (parent == null) {
            parent = super.getParent(node);
            Object[] children = parent == null ? super.getRoots() : super.getChildren(parent);
            this.group(parent, children);
        }
        return (parent = this.mapChild2Parent.get(node)) == NULL ? null : parent;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.fireModelChanged(false);
    }

    public class Group
    implements Unselectable,
    Comparable {
        String label;

        public Group(String label) {
            this.label = label;
        }

        public Group(Object[] children) {
            Object[] args = new Object[]{GroupingTreeModelDecorator.this.labelProvider.getLabel(children[0]), GroupingTreeModelDecorator.this.labelProvider.getLabel(children[children.length - 1])};
            this.label = GroupingTreeModelDecorator.this.format.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }

        public String toString() {
            return this.label;
        }

        public int compareTo(Object o) {
            Group g = (Group)o;
            return Resources.instance().getCollator().compare(this.label, g.label);
        }
    }

    class GroupComparator
    implements Comparator {
        Comparator nodeComparator;

        public GroupComparator(Comparator nodeComparator) {
            this.nodeComparator = nodeComparator;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == NULL && o2 == NULL) {
                return 0;
            }
            if (o1 == NULL) {
                return -1;
            }
            if (o2 == NULL) {
                return 1;
            }
            if (o1 instanceof Group) {
                if (o2 instanceof Group) {
                    return ((Group)o1).compareTo(o2);
                }
                return 1;
            }
            if (o2 instanceof Group) {
                return -1;
            }
            return this.nodeComparator.compare(o1, o2);
        }
    }
}

