/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.VDBDeployer;
import org.teiid.jboss.VDBOperations;
import org.teiid.vdb.runtime.VDBKey;

class AssignDataSource
extends VDBOperations {
    public AssignDataSource() {
        super("assign-datasource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("model-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("model-name.missing")));
        }
        if (!operation.hasDefined("source-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("source-name.missing")));
        }
        if (!operation.hasDefined("translator-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("translator-name.missing")));
        }
        if (!operation.hasDefined("ds-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("ds-name.missing")));
        }
        String modelName = operation.get("model-name").asString();
        String sourceName = operation.get("source-name").asString();
        String translatorName = operation.get("translator-name").asString();
        String dsName = operation.get("ds-name").asString();
        try {
            VDBMetaData vDBMetaData = vdb.getVdb();
            synchronized (vDBMetaData) {
                ServiceName serviceName;
                ServiceRegistry registry;
                ServiceController controller;
                RuntimeVDB.ReplaceResult rr = vdb.assignDatasource(modelName, sourceName, translatorName, dsName);
                if (rr.isNew) {
                    VDBDeployer.addDataSourceListener(context.getServiceTarget(), new VDBKey(vdb.getVdb().getName(), vdb.getVdb().getVersion()), dsName);
                }
                if (rr.removedDs != null && (controller = (registry = context.getServiceRegistry(true)).getService(serviceName = TeiidServiceNames.dsListenerServiceName(vdb.getVdb().getName(), vdb.getVdb().getVersion(), rr.removedDs))) != null) {
                    context.removeService(serviceName);
                }
            }
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        super.describeParameters(operationNode, bundle);
        operationNode.get(new String[]{"request-properties", "model-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "model-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "model-name", "description"}).set(this.getParameterDescription(bundle, "model-name"));
        operationNode.get(new String[]{"request-properties", "source-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "source-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "source-name", "description"}).set(this.getParameterDescription(bundle, "model-name"));
        operationNode.get(new String[]{"request-properties", "translator-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "translator-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "translator-name", "description"}).set(this.getParameterDescription(bundle, "translator-name"));
        operationNode.get(new String[]{"request-properties", "ds-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "ds-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "ds-name", "description"}).set(this.getParameterDescription(bundle, "ds-name"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

