/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;

public abstract class BaseOperationHandler<T>
implements DescriptionProvider,
OperationStepHandler {
    private static final String DESCRIBE = ".describe";
    private static final String REPLY = ".reply";
    protected static final String MISSING = ".missing";
    private String operationName;

    protected BaseOperationHandler(String operationName) {
        this.operationName = operationName;
    }

    public void register(ManagementResourceRegistration subsystem) {
        subsystem.registerOperationHandler(this.operationName, (OperationStepHandler)this, (DescriptionProvider)this);
    }

    public String name() {
        return this.operationName;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode address = operation.require("address");
                    PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
                    BaseOperationHandler.this.executeOperation(context, BaseOperationHandler.this.getService(context, pathAddress, operation), operation);
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected T getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        return null;
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set(this.operationName);
        operation.get("description").set(bundle.getString(this.name() + DESCRIBE));
        ModelNode reply = operation.get("reply-properties");
        reply.get("description").set(bundle.getString(this.name() + REPLY));
        this.describeParameters(operation, bundle);
        return operation;
    }

    protected String getParameterDescription(ResourceBundle bundle, String paramName) {
        return bundle.getString(this.name() + "." + paramName + DESCRIBE);
    }

    protected abstract void executeOperation(OperationContext var1, T var2, ModelNode var3) throws OperationFailedException;

    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
    }

    boolean isValidVDB(OperationContext context, String vdbName, int vdbVersion) {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        VDBRepository repo = (VDBRepository)VDBRepository.class.cast(sc.getValue());
        VDBMetaData vdb = repo.getLiveVDB(vdbName, vdbVersion);
        return vdb != null && vdb.getStatus() == VDB.Status.ACTIVE;
    }
}

