/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SimplePrincipal;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;
import org.teiid.security.Credentials;
import org.teiid.services.SessionServiceImpl;
import org.teiid.services.TeiidLoginContext;

public class JBossSessionService
extends SessionServiceImpl {
    private Map<String, SecurityDomainContext> securityDomainMap;

    public JBossSessionService(Map<String, SecurityDomainContext> securityDomainMap) {
        this.securityDomainMap = securityDomainMap;
    }

    protected TeiidLoginContext authenticate(String userName, Credentials credentials, String applicationName, List<String> domains) throws LoginException {
        String baseUsername = JBossSessionService.getBaseUsername((String)userName);
        for (String domain : this.getDomainsForUser(domains, userName)) {
            Subject subject;
            String credString;
            SimplePrincipal userPrincipal;
            boolean isValid;
            AuthenticationManager authManager;
            SecurityDomainContext securityDomainContext = this.securityDomainMap.get(domain);
            if (securityDomainContext == null || (authManager = securityDomainContext.getAuthenticationManager()) == null || !(isValid = authManager.isValid((Principal)(userPrincipal = new SimplePrincipal(userName)), (Object)(credString = credentials == null ? null : new String(credentials.getCredentialsAsCharArray())), subject = new Subject()))) continue;
            String qualifiedUserName = baseUsername + "@" + domain;
            Object securityContext = this.securityHelper.createSecurityContext(domain, (Principal)userPrincipal, (Object)credString, subject);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful for \"", userName, "\""});
            return new TeiidLoginContext(qualifiedUserName, subject, domain, securityContext);
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50072, new Object[]{userName}));
    }
}

