/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;

public class RequestRateThrottleFilter
implements Filter {
    private int hits = 5;
    private int period = 10;
    private static final String HITS = "hits";
    private static final String PERIOD = "period";

    public void init(FilterConfig filterConfig) {
        this.hits = Integer.parseInt(filterConfig.getInitParameter(HITS));
        this.period = Integer.parseInt(filterConfig.getInitParameter(PERIOD));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(true);
        String string = session.getId().intern();
        synchronized (string) {
            Stack<Date> times = (Stack<Date>)ESAPI.httpUtilities().getSessionAttribute("times");
            if (times == null) {
                times = new Stack<Date>();
                times.push(new Date(0L));
                session.setAttribute("times", times);
            }
            times.push(new Date());
            if (times.size() >= this.hits) {
                times.removeElementAt(0);
            }
            Date newest = (Date)times.get(times.size() - 1);
            Date oldest = (Date)times.get(0);
            long elapsed = newest.getTime() - oldest.getTime();
            if (elapsed < (long)(this.period * 1000)) {
                response.getWriter().println("Request rate too high");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

