/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.IllegalParameterException;
import org.mariadb.jdbc.internal.common.query.ParameterizedQuery;
import org.mariadb.jdbc.internal.common.query.QueryType;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;

public class MySQLParameterizedQuery
implements ParameterizedQuery {
    private ParameterHolder[] parameters;
    private final int paramCount;
    private final String query;
    private final byte[][] queryPartsArray;

    public MySQLParameterizedQuery(String query, boolean noBackslashEscapes) {
        this.query = query;
        List<String> queryParts = Utils.createQueryParts(query, noBackslashEscapes);
        this.queryPartsArray = new byte[queryParts.size()][];
        for (int i = 0; i < queryParts.size(); ++i) {
            try {
                this.queryPartsArray[i] = queryParts.get(i).getBytes("UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 not supported", e);
            }
        }
        this.paramCount = queryParts.size() - 1;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    public MySQLParameterizedQuery(ParameterizedQuery paramQuery) {
        this.query = paramQuery.getQuery();
        this.queryPartsArray = paramQuery.getQueryPartsArray();
        this.paramCount = this.queryPartsArray.length - 1;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public void setParameter(int position, ParameterHolder parameter) throws IllegalParameterException {
        if (position < 0 || position >= this.paramCount) {
            throw new IllegalParameterException("No '?' on that position");
        }
        this.parameters[position] = parameter;
    }

    @Override
    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public void validate() throws QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException, QueryException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(this.queryPartsArray[0]);
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            this.parameters[i - 1].writeTo(os);
            if (this.queryPartsArray[i].length == 0) continue;
            os.write(this.queryPartsArray[i]);
        }
    }

    private boolean containsNull(ParameterHolder[] parameters) {
        for (ParameterHolder ph : parameters) {
            if (ph != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public byte[][] getQueryPartsArray() {
        return this.queryPartsArray;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public String toString() {
        return this.query;
    }
}

