/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.excel;

import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.NumberFormat;
import com.tonbeller.jpivot.table.CellBuilder;
import com.tonbeller.jpivot.table.CellBuilderDecorator;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.RequestContext;
import org.w3c.dom.Element;

public class ExcelCellBuilderDecorator
extends CellBuilderDecorator {
    protected boolean excelMode;

    public void startBuild(RequestContext context) {
        super.startBuild(context);
        this.excelMode = RendererParameters.isExcelMode((RequestContext)context);
    }

    public ExcelCellBuilderDecorator(CellBuilder delegate) {
        super(delegate);
    }

    public Element build(Cell cell, boolean even) {
        Element cellElem = super.build(cell, even);
        if (this.excelMode && !cell.isNull() && cell.getValue() instanceof Number) {
            Object value = cell.getValue();
            NumberFormat nf = cell.getFormat();
            String rawValue = value.toString();
            cellElem.setAttribute("rawvalue", rawValue);
            Number num = (Number)cell.getValue();
            String numFormat = "\\#\\#0";
            String string = numFormat = nf.isGrouping() ? "\\#\\," + numFormat : numFormat;
            if (nf.getFractionDigits() > 0) {
                numFormat = numFormat + ".";
                for (int x = 0; x < nf.getFractionDigits(); ++x) {
                    numFormat = numFormat + "#";
                }
            }
            String msoformat = nf.isPercent() ? "Percent" : numFormat;
            cellElem.setAttribute("mso-number-format", msoformat);
        }
        return cellElem;
    }
}

